/* file      : xsde/config.h.in
 * license   : GNU GPL v2; see accompanying LICENSE file
 */

#ifndef XSDE_CONFIG_H
#define XSDE_CONFIG_H

/* C++11 support.
 */
#ifdef _MSC_VER
#  if _MSC_VER >= 1600 // VC++10 and later have C++11 always enabled.
#    define XSDE_CXX11
#  endif
#else
#  if defined(__GXX_EXPERIMENTAL_CXX0X__) || __cplusplus >= 201103L
#    define XSDE_CXX11
#  endif
#endif

/* Platform and its architecture width in bits.
 */
#if defined(_WIN32)
#  define XSDE_PLATFORM_WIN32 1
#  if defined(_WIN64)
#    define XSDE_ARCH_WIDTH   64
#  else
#    define XSDE_ARCH_WIDTH   32
#  endif
#else
#  define XSDE_PLATFORM_POSIX 1
#  if defined(__x86_64__) || defined(__aarch64__) || defined(__arm64__)
#    define XSDE_ARCH_WIDTH   64
#  elif defined(__i386__) || defined(__arm__)
#    define XSDE_ARCH_WIDTH   32
#  else
#    error unknown architecture width
#  endif
#endif

/* Platform byte order.
 */
/* Include the endianness header based on platform.
 *
 * Each of these headers should define BYTE_ORDER, LITTLE_ENDIAN, BIG_ENDIAN,
 * AND PDP_ENDIAN but this can be affected by macros like _ANSI_SOURCE,
 * _POSIX_C_SOURCE, _XOPEN_SOURCE and _NETBSD_SOURCE, depending on the
 * platform (in which case most of them define underscored versions only).
 */
#if defined(__GLIBC__) || defined(__OpenBSD__)
#  include <endian.h>
#elif defined(__FreeBSD__) || defined(__NetBSD__)
#  include <sys/endian.h>
#elif defined(__APPLE__)
#  include <machine/endian.h>
#elif !defined(_WIN32)
#  include <sys/param.h>
#endif

/* Try various system- and compiler-specific byte order macro names if the
 * endianness headers did not define BYTE_ORDER.
 */
#if !defined(BYTE_ORDER)
#  if defined(__linux__)
#    if defined(__BYTE_ORDER)
#      define BYTE_ORDER    __BYTE_ORDER
#      define BIG_ENDIAN    __BIG_ENDIAN
#      define LITTLE_ENDIAN __LITTLE_ENDIAN
#    endif
#  elif defined(__FreeBSD__) || defined(__OpenBSD__) || defined(__NetBSD__)
#    if defined(_BYTE_ORDER)
#      define BYTE_ORDER    _BYTE_ORDER
#      define BIG_ENDIAN    _BIG_ENDIAN
#      define LITTLE_ENDIAN _LITTLE_ENDIAN
#    endif
#  elif defined(__APPLE__)
#    if defined(__DARWIN_BYTE_ORDER)
#      define BYTE_ORDER    __DARWIN_BYTE_ORDER
#      define BIG_ENDIAN    __DARWIN_BIG_ENDIAN
#      define LITTLE_ENDIAN __DARWIN_LITTLE_ENDIAN
#    endif
#  elif defined(_WIN32)
#    define BIG_ENDIAN    4321
#    define LITTLE_ENDIAN 1234
#    define BYTE_ORDER    LITTLE_ENDIAN
#  elif defined(__BYTE_ORDER__) &&       \
        defined(__ORDER_BIG_ENDIAN__) && \
        defined(__ORDER_LITTLE_ENDIAN__)
     /* GCC, Clang (and others, potentially).
      */
#    define BYTE_ORDER    __BYTE_ORDER__
#    define BIG_ENDIAN    __ORDER_BIG_ENDIAN__
#    define LITTLE_ENDIAN __ORDER_LITTLE_ENDIAN__
#  endif
#endif

#ifndef BYTE_ORDER
#  error no byte order macros defined
#endif
#define XSDE_BYTEORDER BYTE_ORDER

/* Application character encoding.
 */
#define XSDE_ENCODING_UTF8 1
#undef XSDE_ENCODING_ISO8859_1

/* Use of STL.
 */
#define XSDE_STL 1

/* Conformance of iterators to STL requirements.
 */
#define XSDE_STL_ITERATOR 1

/* Use of std::iostream.
 */
#define XSDE_IOSTREAM 1

/* Use of C++ exceptions.
 */
#define XSDE_EXCEPTIONS 1

/* Use of the "long long int" type and the strtoull() function.
 */
#define XSDE_LONGLONG 1

/* The platform has the snprintf() function.
 *
 * Note that VC 14 introduces the snprintf() function (see xsde/cxx/config.hxx
 * for details).
 */
#if defined(XSDE_PLATFORM_POSIX) || (defined(_MSC_VER) && _MSC_VER >= 1900)
#  define XSDE_SNPRINTF 1
#endif

#define XSDE_PARSER_VALIDATION 1
#define XSDE_SERIALIZER_VALIDATION 1
#define XSDE_REGEXP 1
#undef XSDE_REUSE_STYLE_MIXIN
#define XSDE_REUSE_STYLE_TIEIN 1
#undef XSDE_REUSE_STYLE_NONE
#undef XSDE_CUSTOM_ALLOCATOR
#undef XSDE_DEFAULT_ALLOCATOR
#define XSDE_POLYMORPHIC 1

#ifdef XSDE_POLYMORPHIC
#  define XSDE_PARSER_SMAP_BUCKETS            389
#  ifdef XSDE_PARSER_VALIDATION
#    define XSDE_PARSER_IMAP_BUCKETS          769
#  endif
#  define XSDE_SERIALIZER_SMAP_BUCKETS        389
#  define XSDE_SERIALIZER_SMAP_BUCKET_BUCKETS 389
#  ifdef XSDE_SERIALIZER_VALIDATION
#    define XSDE_SERIALIZER_IMAP_BUCKETS      769
#  endif
#endif

#undef XSDE_EXTERNAL_EXPAT

#endif /* XSDE_CONFIG_H */
