// file      : xsde/cxx/qname.ixx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2008 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <string.h> // strcmp

namespace xsde
{
  namespace cxx
  {
    // c-tors, d-tor and swap
    //
    inline qname::
    ~qname ()
    {
      delete[] prefix_;
      delete[] name_;
    }

    inline qname::
    qname ()
        : prefix_ (0), name_ (0)
    {
    }

#ifdef XSDE_EXCEPTIONS
    inline qname::
    qname (const char* n)
        : prefix_ (0), name_ (0)
    {
      prefix ("");
      name (n);
    }

    inline qname::
    qname (const char* p, const char* n)
        : prefix_ (0), name_ (0)
    {
      prefix (p);
      name (n);
    }
#endif

    inline void qname::
    swap (qname& x)
    {
      char* p = prefix_;
      char* n = name_;

      prefix_ = x.prefix_;
      name_ = x.name_;

      x.prefix_ = p;
      x.name_ = n;
    }

    // preix
    //
    inline char* qname::
    prefix ()
    {
      return prefix_;
    }

    inline const char* qname::
    prefix () const
    {
      return prefix_;
    }

    inline char* qname::
    detach_prefix ()
    {
      char* r = prefix_;
      prefix_ = 0;
      return r;
    }

    inline void qname::
    attach_prefix (char* prefix)
    {
      delete[] prefix_;
      prefix_ = prefix;
    }

    // name
    //
    inline char* qname::
    name ()
    {
      return name_;
    }

    inline const char* qname::
    name () const
    {
      return name_;
    }

    inline char* qname::
    detach_name ()
    {
      char* r = name_;
      name_ = 0;
      return r;
    }

    inline void qname::
    attach_name (char* name)
    {
      delete[] name_;
      name_ = name;
    }

    //
    //
    inline bool
    operator== (const qname& x, const qname& y)
    {
      return strcmp (x.name (), y.name ()) == 0 &&
        strcmp (x.prefix (), y.prefix ()) == 0;
    }

    inline bool
    operator!= (const qname& x, const qname& y)
    {
      return !(x == y);
    }
  }
}
