// file      : xsde/cxx/parser/validating/idrefs.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2008 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsde/cxx/pre.hxx>

#include <xsde/cxx/config.hxx>

#include <xsde/cxx/parser/validating/idrefs.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
      namespace validating
      {
        idrefs_pimpl::
        ~idrefs_pimpl ()
        {
          delete seq_;
        }

        idrefs_pimpl::
        idrefs_pimpl ()
            : seq_ (0)
        {
        }

        void idrefs_pimpl::
        _pre ()
        {
          delete seq_;
          seq_ = new string_sequence ();

#ifndef XSDE_EXCEPTIONS
          if (seq_ == 0)
          {
            _sys_error (sys_error::no_memory);
            return;
          }
#endif
          idrefs_pskel::_pre ();
        }

        void idrefs_pimpl::
        _post ()
        {
          idrefs_pskel::_post ();

          // Should have at least one element.
          //
          if (!_context ().error_type () && seq_->size () < 1)
            _schema_error (schema_error::invalid_idrefs_value);
        }

        string_sequence* idrefs_pimpl::
        post_idrefs ()
        {
          string_sequence* r = seq_;
          seq_ = 0;
          return r;
        }

        void idrefs_pimpl::
        _xsde_parse_item (const ro_string& s)
        {
          context& ctx = _context ();

          parser_.pre ();

#ifndef XSDE_EXCEPTIONS
          if (!parser_._error_type ())
            parser_._pre_impl (ctx);
          else
            parser_._copy_error (ctx);
#else
          parser_._pre_impl (ctx);
#endif
          if (!ctx.error_type ())
            parser_._characters (s);

          if (!ctx.error_type ())
            parser_._post_impl ();

          if (!ctx.error_type ())
          {
            char* x = parser_.post_idref ();

#ifndef XSDE_EXCEPTIONS
            if (!parser_._error_type ())
            {
              if (seq_->push_back_attach (x))
              {
                delete[] x;
                _sys_error (sys_error::no_memory);
              }
            }
            else
              parser_._copy_error (ctx);
#else
            seq_->push_back_attach (x);
#endif
          }
        }

        void idrefs_pimpl::
        _reset ()
        {
          idrefs_pskel::_reset ();
          parser_._reset ();
        }
      }
    }
  }
}

#include <xsde/cxx/post.hxx>
