// file      : xsde/cxx/parser/non-validating/nmtokens-stl.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2008 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsde/cxx/config.hxx>

#include <xsde/cxx/parser/non-validating/nmtokens-stl.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
      namespace non_validating
      {
        void nmtokens_pimpl::
        _pre ()
        {
          seq_.clear ();
          nmtokens_pskel::_pre ();
        }

        string_sequence nmtokens_pimpl::
        post_nmtokens ()
        {
          string_sequence r;
          r.swap (seq_);
          return r;
        }

        void nmtokens_pimpl::
        _reset ()
        {
          nmtokens_pskel::_reset ();
          parser_._reset ();
        }

        void nmtokens_pimpl::
        _xsde_parse_item (const ro_string& s)
        {
          parser_.pre ();
          parser_._pre_impl (_context ());
          parser_._characters (s);
          parser_._post_impl ();
          seq_.push_back (parser_.post_nmtoken ());
        }
      }
    }
  }
}
