// file      : xsde/cxx/string-sequence.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2008 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef XSDE_CXX_STRING_SEQUENCE_HXX
#define XSDE_CXX_STRING_SEQUENCE_HXX

#include <stddef.h> // size_t

#include <xsde/cxx/config.hxx>

namespace xsde
{
  namespace cxx
  {
    class string_sequence
    {
    public:
#ifndef XSDE_EXCEPTIONS
      enum error
      {
        error_none,
        error_no_memory
      };
#endif

      typedef char** iterator;
      typedef const char* const* const_iterator;

    public:
      ~string_sequence ();
      string_sequence ();

      void
      swap (string_sequence&);

    private:
      string_sequence (string_sequence&);

      string_sequence&
      operator= (string_sequence&);

    public:
      iterator
      begin ();

      const_iterator
      begin () const;

      iterator
      end ();

      const_iterator
      end () const;

      char*
      front ();

      const char*
      front () const;

      char*
      back ();

      const char*
      back () const;

      char*
      operator[] (size_t);

      const char*
      operator[] (size_t) const;

    public:
      bool
      empty () const;

      size_t
      size () const;

    public:
#ifndef XSDE_EXCEPTIONS
      error
#else
      void
#endif
      push_back (const char*);

#ifndef XSDE_EXCEPTIONS
      error
#else
      void
#endif
      push_back_attach (char*);

      void
      pop_back ();

      // Detach a string from the sequence at a given position.
      // The string pointer at this position in the sequence is
      // set to 0.
      //
      char*
      detach (iterator);

    private:
#ifndef XSDE_EXCEPTIONS
      error
#else
      void
#endif
      grow ();

    private:
      char** data_;
      size_t size_;
      size_t capacity_;
    };

    bool
    operator== (const string_sequence&, const string_sequence&);

    bool
    operator!= (const string_sequence&, const string_sequence&);
  }
}

#include <xsde/cxx/string-sequence.ixx>

#endif  // XSDE_CXX_STRING_SEQUENCE_HXX
