// file      : xsde/cxx/string-sequence-stl.ixx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2008 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

namespace xsde
{
  namespace cxx
  {
    inline string_sequence::
    string_sequence ()
    {
    }

    inline string_sequence::
    string_sequence (size_type n, const value_type& x)
        : std::vector<std::string> (n, x)
    {
    }

    template <typename I>
    inline string_sequence::
    string_sequence (const I& begin, const I& end)
        : std::vector<std::string> (begin, end)
    {
    }

    inline bool
    operator!= (const string_sequence& x, const string_sequence& y)
    {
      return !(x == y);
    }
  }
}
