// file      : xsde/cxx/serializer/validating/byte.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2008 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <stdio.h> // sprintf/snprintf

#include <xsde/cxx/serializer/validating/byte.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace serializer
    {
      namespace validating
      {
        void byte_simpl::
        pre (signed char value)
        {
          value_ = value;
        }

        void byte_simpl::
        _serialize_content ()
        {
          // We only need strlen("-128") + 1 characters to hold all
          // representations of signed byte.
          //
          char str[5];

#ifdef XSDE_SNPRINTF
          int n = snprintf (str, 5, "%d", value_);
#else
          int n = sprintf (str, "%d", value_);
#endif
          if (n > 0 && n < 5)
            _characters (str, static_cast<size_t> (n));
          else
            _schema_error (schema_error::invalid_byte_value);
        }
      }
    }
  }
}
