// file      : xsde/cxx/parser/non-validating/qname.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2008 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsde/cxx/config.hxx>
#include <xsde/cxx/string.hxx>

#include <xsde/cxx/parser/non-validating/qname.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
      namespace non_validating
      {
        void qname_pimpl::
        _pre ()
        {
#ifdef XSDE_EXCEPTIONS
          str_.assign ("", 0);
#else
          if (str_.assign ("", 0))
            _sys_error (sys_error::no_memory);
#endif
        }

        void qname_pimpl::
        _characters (const ro_string& s)
        {
          if (str_.size () == 0)
          {
            ro_string tmp (s.data (), s.size ());

            if (trim_left (tmp) != 0)
            {
#ifdef XSDE_EXCEPTIONS
              str_.append (tmp.data (), tmp.size ());
#else
              if (str_.append (tmp.data (), tmp.size ()))
                _sys_error (sys_error::no_memory);
#endif
            }
          }
          else
          {
#ifdef XSDE_EXCEPTIONS
            str_.append (s.data (), s.size ());
#else
            if (str_.append (s.data (), s.size ()))
              _sys_error (sys_error::no_memory);
#endif
          }
        }

        struct qname_guard
        {
          ~qname_guard () { delete p_; }
          qname_guard (qname* p) : p_ (p) {}

          void
          release () { p_ = 0; }

        private:
          qname* p_;
        };

        qname* qname_pimpl::
        post_qname ()
        {
          qname* r = new qname ();

#ifndef XSDE_EXCEPTIONS
          if (r == 0)
          {
            _sys_error (sys_error::no_memory);
            return 0;
          }
#endif
          qname_guard rg (r);

          ro_string tmp (str_.data (), str_.size ());
          ro_string::size_type size = trim_right (tmp);
          ro_string::size_type pos = tmp.find (':');

          const char* s = tmp.data ();

          string prefix;
          string name;

          if (pos != ro_string::npos)
          {
#ifdef XSDE_EXCEPTIONS
            prefix.assign (s, pos);
            name.assign (s + pos + 1, size - pos - 1);
#else
            if (prefix.assign (s, pos) ||
                name.assign (s + pos + 1, size - pos - 1))
            {
              _sys_error (sys_error::no_memory);
              return 0;
            }
#endif
          }
          else
          {
#ifdef XSDE_EXCEPTIONS
            prefix.assign ("", 0);
#else
            if (prefix.assign ("", 0))
            {
              _sys_error (sys_error::no_memory);
              return 0;
            }
#endif
            str_.truncate (size);
            name.swap (str_);
          }

          r->attach_prefix (prefix.detach ());
          r->attach_name (name.detach ());

          rg.release ();
          return r;
        }
      }
    }
  }
}
