// file      : xsde/cxx/string-sequence-stl.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef XSDE_CXX_STRING_SEQUENCE_STL_HXX
#define XSDE_CXX_STRING_SEQUENCE_STL_HXX

#include <vector>
#include <string>

namespace xsde
{
  namespace cxx
  {
    class string_sequence: public std::vector<std::string>
    {
    public:
      string_sequence ();

      explicit
      string_sequence (size_type n, const value_type& x = value_type ());

      template <typename I>
      string_sequence (const I& begin, const I& end);
    };

    bool
    operator== (const string_sequence&, const string_sequence&);

    bool
    operator!= (const string_sequence&, const string_sequence&);
  }
}

#include <xsde/cxx/string-sequence-stl.ixx>

#endif  // XSDE_CXX_STRING_SEQUENCE_STL_HXX
