// file      : xsde/cxx/serializer/non-validating/xml-schema-sskel.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef XSDE_CXX_SERIALIZER_NON_VALIDATING_XML_SCHEMA_SSKEL_HXX
#define XSDE_CXX_SERIALIZER_NON_VALIDATING_XML_SCHEMA_SSKEL_HXX

#include <xsde/cxx/config.hxx>

#ifdef XSDE_STL
#  include <string>
#endif

#include <xsde/cxx/serializer/xml-schema.hxx>

#include <xsde/cxx/serializer/non-validating/serializer.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace serializer
    {
      namespace non_validating
      {
        // anyType and anySimpleType.
        //
        struct any_type_sskel: virtual complex_content
        {
          virtual void
          pre () = 0;

          // Override the following two functions to implement
          // your logic.
          //

          // virtual void
          // _serialize_attributes ();

          // virtual void
          // _serialize_content ();
        };

        struct any_simple_type_sskel: virtual simple_content
        {
          virtual void
          pre () = 0;

          // Override the following function to implement your
          // logic.
          //

          // virtual void
          // _serialize_content ();
        };

        // Boolean.
        //
        struct boolean_sskel: virtual simple_content
        {
          virtual void
          pre (bool) = 0;
        };

        // 8-bit
        //

        struct byte_sskel: virtual simple_content
        {
          virtual void
          pre (signed char) = 0;
        };

        struct unsigned_byte_sskel: virtual simple_content
        {
          virtual void
          pre (unsigned char) = 0;
        };


        // 16-bit
        //

        struct short_sskel: virtual simple_content
        {
          virtual void
          pre (short) = 0;
        };

        struct unsigned_short_sskel: virtual simple_content
        {
          virtual void
          pre (unsigned short) = 0;
        };

        // 32-bit
        //

        struct int_sskel: virtual simple_content
        {
          virtual void
          pre (int) = 0;
        };

        struct unsigned_int_sskel: virtual simple_content
        {
          virtual void
          pre (unsigned int) = 0;
        };

        // 64-bit
        //

#ifdef XSDE_LONGLONG
        struct long_sskel: virtual simple_content
        {
          virtual void
          pre (long long) = 0;
        };

        struct unsigned_long_sskel: virtual simple_content
        {
          virtual void
          pre (unsigned long long) = 0;
        };
#else
        struct long_sskel: virtual simple_content
        {
          virtual void
          pre (long) = 0;
        };

        struct unsigned_long_sskel: virtual simple_content
        {
          virtual void
          pre (unsigned long) = 0;
        };
#endif

        // Arbitrary-length integers.
        //

        struct integer_sskel: virtual simple_content
        {
          virtual void
          pre (long) = 0;
        };

        struct negative_integer_sskel: virtual simple_content
        {
          virtual void
          pre (long) = 0;
        };

        struct non_positive_integer_sskel: virtual simple_content
        {
          virtual void
          pre (long) = 0;
        };

        struct positive_integer_sskel: virtual simple_content
        {
          virtual void
          pre (unsigned long) = 0;
        };

        struct non_negative_integer_sskel: virtual simple_content
        {
          virtual void
          pre (unsigned long) = 0;
        };

        // Floats.
        //

        struct float_sskel: virtual simple_content
        {
          virtual void
          pre (float) = 0;
        };

        struct double_sskel: virtual simple_content
        {
          virtual void
          pre (double) = 0;
        };

        struct decimal_sskel: virtual simple_content
        {
          virtual void
          pre (double) = 0;
        };

        // String-based types.
        //
#ifdef XSDE_STL

        struct string_sskel: virtual simple_content
        {
          virtual void
          pre (const std::string&) = 0;
        };

        struct normalized_string_sskel: virtual string_sskel
        {
        };

        struct token_sskel: virtual normalized_string_sskel
        {
        };

        struct name_sskel: virtual token_sskel
        {
        };

        struct nmtoken_sskel: virtual token_sskel
        {
        };

        struct nmtokens_sskel: virtual simple_content
        {
          virtual void
          pre (const string_sequence&) = 0;
        };

        struct ncname_sskel: virtual name_sskel
        {
        };

        struct id_sskel: virtual ncname_sskel
        {
        };

        struct idref_sskel: virtual ncname_sskel
        {
        };

        struct idrefs_sskel: virtual simple_content
        {
          virtual void
          pre (const string_sequence&) = 0;
        };

        struct language_sskel: virtual token_sskel
        {
        };

        struct uri_sskel: virtual simple_content
        {
          virtual void
          pre (const std::string&) = 0;
        };

        struct qname_sskel: virtual simple_content
        {
          virtual void
          pre (const qname&) = 0;
        };

#else // XSDE_STL

        struct string_sskel: virtual simple_content
        {
          virtual void
          pre (const char*) = 0;
        };

        struct normalized_string_sskel: virtual string_sskel
        {
        };

        struct token_sskel: virtual normalized_string_sskel
        {
        };

        struct name_sskel: virtual token_sskel
        {
        };

        struct nmtoken_sskel: virtual token_sskel
        {
        };

        struct nmtokens_sskel: virtual simple_content
        {
          virtual void
          pre (const string_sequence*) = 0;
        };

        struct ncname_sskel: virtual name_sskel
        {
        };

        struct id_sskel: virtual ncname_sskel
        {
        };

        struct idref_sskel: virtual ncname_sskel
        {
        };

        struct idrefs_sskel: virtual simple_content
        {
          virtual void
          pre (const string_sequence*) = 0;
        };

        struct language_sskel: virtual token_sskel
        {
        };

        struct uri_sskel: virtual simple_content
        {
          virtual void
          pre (const char*) = 0;
        };

        struct qname_sskel: virtual simple_content
        {
          virtual void
          pre (const qname*) = 0;
        };

#endif // XSDE_STL


        // base64Binary
        //
        struct base64_binary_sskel: virtual simple_content
        {
          virtual void
          pre (const buffer*) = 0;
        };

        // hexBinary
        //
        struct hex_binary_sskel: virtual simple_content
        {
          virtual void
          pre (const buffer*) = 0;
        };

        // Time and date types.
        //
        struct gday_sskel: virtual simple_content
        {
          virtual void
          pre (const gday&) = 0;
        };

        struct gmonth_sskel: virtual simple_content
        {
          virtual void
          pre (const gmonth&) = 0;
        };

        struct gyear_sskel: virtual simple_content
        {
          virtual void
          pre (const gyear&) = 0;
        };

        struct gmonth_day_sskel: virtual simple_content
        {
          virtual void
          pre (const gmonth_day&) = 0;
        };

        struct gyear_month_sskel: virtual simple_content
        {
          virtual void
          pre (const gyear_month&) = 0;
        };

        struct date_sskel: virtual simple_content
        {
          virtual void
          pre (const date&) = 0;
        };

        struct time_sskel: virtual simple_content
        {
          virtual void
          pre (const time&) = 0;
        };

        struct date_time_sskel: virtual simple_content
        {
          virtual void
          pre (const date_time&) = 0;
        };

        struct duration_sskel: virtual simple_content
        {
          virtual void
          pre (const duration&) = 0;
        };
      }
    }
  }
}

#endif  // XSDE_CXX_SERIALIZER_NON_VALIDATING_XML_SCHEMA_SSKEL_HXX
