# Toolchain.
#
CC       := gcc
CXX      := g++

CPPFLAGS :=

CFLAGS   := -W -Wall -O3
CXXFLAGS := -W -Wall -O3

LDFLAGS  :=
LIBS     :=

# Set RANLIB to empty if your system does not need ranlib.
#
AR       := ar
RANLIB   := ranlib


# Common XSD/e flags.
#
XSDFLAGS := --generate-inline


# Platform. Valid values are:
#
# 'wince'  - Windows CE
# 'win32'  - Windows 2000, XP, etc.
# 'posix'  - POSIX OS, including UNIX/Linux, VxWorks, etc.
#
XSDE_PLATFORM   := posix


# Platform byte order. Valid values are 'b' for big-endian
# and 'l' for little-endian.
#
XSDE_BYTEORDER  := l


# Set to 'n' if you don't have STL (std::string, etc.). Also don't
# forget to use the --no-stl option when compiling your schemas.
#
XSDE_STL        := y


# Set to 'n' if you don't have iostream.
#
XSDE_IOSTREAM   := y


# Set to 'n' if you don't have C++ exceptions. Also don't forget to
# use the --no-exceptions option when compiling your schemas.
#
XSDE_EXCEPTIONS := y


# Set to 'n' if you don't want support for XML Schema validation in
# C++/Parser. Also don't forget to use the --suppress-validation
# option when compiling your schemas.
#
XSDE_VALIDATION_PARSER := y


# Set to 'n' if you don't want support for XML Schema validation in
# C++/Serializer. Also don't forget to use the --suppress-validation
# option when compiling your schemas.
#
XSDE_VALIDATION_SERIALIZER := y


# Set to 'n' if your platform doesn't have the "long long int" type or
# the strtoull function. Also don't forget to use the --no-long-long
# option when compiling your schemas.
#
XSDE_LONGLONG   := y


# Set to 'n' if your platform doesn't have the snprintf function.
#
XSDE_SNPRINTF   := y


# Options tuning depending on the features selected.
#
ifeq ($(XSDE_EXCEPTIONS),y)
CFLAGS += -fexceptions
endif
