// file      : xsde/cxx/parser/string-sequence-stl.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsde/cxx/parser/string-sequence-stl.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
      bool
      operator== (const string_sequence& x, const string_sequence& y)
      {
        if (x.size () != y.size ())
          return false;

        for (string_sequence::const_iterator
               xi (x.begin ()), yi (y.begin ()), xe (x.end ());
             xi != xe; ++xi, ++yi)
        {
          if (*xi != *yi)
            return false;
        }

        return true;
      }
    }
  }
}
