// file      : xsde/cxx/parser/non-validating/idrefs.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsde/cxx/pre.hxx>

#include <xsde/cxx/config.hxx>

#include <xsde/cxx/parser/non-validating/idrefs-stl.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
      namespace non_validating
      {
        void idrefs_pimpl::
        _pre ()
        {
          seq_.clear ();
          idrefs_pskel::_pre ();
        }

        string_sequence idrefs_pimpl::
        post_idrefs ()
        {
          string_sequence r;
          r.swap (seq_);
          return r;
        }

        void idrefs_pimpl::
        _xsde_parse_item (const ro_string& s)
        {
          parser_.pre ();
          parser_._pre ();
          parser_._characters (s);
          parser_._post ();
          seq_.push_back (parser_.post_idref ());
        }
      }
    }
  }
}

#include <xsde/cxx/post.hxx>
