// file      : examples/cxx/parser/minimal/driver.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : not copyrighted - public domain

#include <stdio.h>
#include <string.h>

#include "people-pskel.hxx"

struct gender_pimpl: gender_pskel, xml_schema::string_pimpl
{
  virtual gender
  post_gender ()
  {
    char* s = post_string ();

    gender g = strcmp (s, "male") ? female : male;

    delete[] s;
    return g;
  }
};

struct person_pimpl: person_pskel
{
  virtual void
  first_name (char* n)
  {
    printf ("first: %s\n", n);
    delete[] n;
  }

  virtual void
  last_name (char* n)
  {
    printf ("last: %s\n", n);
    delete[] n;
  }

  virtual void
  gender (::gender g)
  {
    switch (g)
    {
    case male:
      {
        printf ("gender: male\n");
        break;
      }
    case female:
      {
        printf ("gender: female\n");
        break;
      }
    }
  }

  virtual void
  age (short a)
  {
    printf ("age: %hd\n", a);
  }
};

struct people_pimpl: people_pskel
{
  virtual void
  person ()
  {
    // Add an extra newline after each person record.
    //
    printf ("\n");
  }
};

int
main (int argc, char* argv[])
{
  if (argc != 2)
  {
    fprintf (stderr, "usage: %s people.xml\n", argv[0]);
    return 1;
  }

  // Construct the parser.
  //
  xml_schema::short_pimpl short_p;
  xml_schema::string_pimpl string_p;

  gender_pimpl gender_p;
  person_pimpl person_p;
  people_pimpl people_p;

  person_p.parsers (string_p, string_p, gender_p, short_p);
  people_p.parsers (person_p);

  // Open the file.
  //
  FILE* f = fopen (argv[1], "rb");

  if (f == 0)
  {
    fprintf (stderr, "%s: unable to open\n", argv[1]);
    return 1;
  }

  // Parse.
  //
  using xml_schema::error;
  error e;
  bool io_error = false;

  do
  {
    xml_schema::document doc_p (people_p, "people");

    if (e = doc_p.error ())
      break;

    people_p.pre ();

    if (e = people_p.error ())
      break;

    char buf[4096];

    do
    {
      size_t s = fread (buf, 1, sizeof (buf), f);

      if (s != sizeof (buf) && ferror (f))
      {
        io_error = true;
        break;
      }

      doc_p.parse (buf, s, feof (f) != 0);
      e = doc_p.error ();

    } while (!e && !feof (f));

    if (io_error || e)
      break;

    people_p.post_people ();

    e = people_p.error ();

  } while (false);

  fclose (f);

  // Handle errors.
  //

  if (io_error)
  {
    fprintf (stderr, "%s: read failure\n", argv[1]);
    return 1;
  }

  if (e)
  {
    switch (e.type ())
    {
    case error::sys:
      {
        fprintf (stderr, "%s: %s\n", argv[1], e.sys_text ());
        break;
      }
    case error::xml:
      {
        fprintf (stderr, "%s:%lu:%lu: %s\n",
                 argv[1], e.line (), e.column (), e.xml_text ());
        break;
      }
#ifdef XSDE_VALIDATION
    case error::schema:
      {
        fprintf (stderr, "%s:%lu:%lu: %s\n",
                 argv[1], e.line (), e.column (), e.schema_text ());
        break;
      }
#endif
    case error::app:
      {
        fprintf (stderr, "%s:%lu:%lu: application error %d\n",
                 argv[1], e.line (), e.column (), e.app_code ());
        break;
      }
    default:
      break;
    }

    return 1;
  }

  return 0;
}
