// file      : xsde/cxx/parser/validating/nmtokens.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsde/cxx/config.hxx>

#include <xsde/cxx/parser/validating/nmtokens-stl.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
      namespace validating
      {
        void nmtokens_pimpl::
        _pre ()
        {
          seq_.clear ();
          nmtokens_pskel::_pre ();
        }

        void nmtokens_pimpl::
        _post ()
        {
          nmtokens_pskel::_post ();

          // Should have at least one element.
          //
          if (!error_p_ () && seq_.size () < 1)
            schema_error (schema_error::invalid_nmtokens_value);
        }

        string_sequence nmtokens_pimpl::
        post_nmtokens ()
        {
          string_sequence r;
          r.swap (seq_);
          return r;
        }

        void nmtokens_pimpl::
        _xsde_parse_item (const ro_string& s)
        {
          parser_.pre ();

          if (!parser_.error_p_ ())
            parser_._pre ();

          if (!parser_.error_p_ ())
            parser_._characters (s);

          if (!parser_.error_p_ ())
            parser_._post ();

          if (!parser_.error_p_ ())
          {
            const std::string& s = parser_.post_nmtoken ();

            if (!parser_.error_p_ ())
            {
              seq_.push_back (s);
            }
          }

          if (parser_.error_p_ ())
            copy_error_ (&parser_);
        }
      }
    }
  }
}
