// file      : xsde/cxx/parser/validating/ncname-common.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsde/cxx/parser/validating/ncname-common.hxx>
#include <xsde/cxx/parser/validating/char-table.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
      namespace validating
      {
        namespace bits
        {
          bool
          valid_ncname (const char* s, size_t size)
          {
            // For now we are only checking the US-ASCII characters.
            //

            bool ok = (size != 0);

            if (ok)
            {
              unsigned char c = static_cast<unsigned char> (s[0]);

              ok = c >= 0x80 ||
                ((xml::char_table[c] & xml::name_first_char_mask) &&
                 c != ':');

              if (ok)
              {
                for (size_t i = 1; i < size; ++i)
                {
                  c = static_cast<unsigned char> (s[i]);

                  if (c < 0x80 &&
                      !(xml::char_table[c] & xml::ncname_char_mask))
                  {
                    ok = false;
                    break;
                  }
                }
              }
            }

            return ok;
          }
        }
      }
    }
  }
}
