// file      : xsde/cxx/parser/elements.ixx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

namespace xsde
{
  namespace cxx
  {
    namespace parser
    {
#ifndef XSDE_EXCEPTIONS
      inline parser::error parser_base::
      error () const
      {
        switch (error_type_)
        {
        case error_sys:
          {
            return parser::error (error_code_.sys);
          }
        case error_app:
          {
            return parser::error (error_code_.app, 0, 0);
          }
        default:
          {
            return parser::error ();
          }
        }
      }

      inline void parser_base::
      error (int e)
      {
        error_type_ = error_app;
        error_code_.app = e;
      }

      inline int parser_base::
      app_error () const
      {
        return error_code_.app;
      }

      inline parser_base::sys_error_t parser_base::
      sys_error () const
      {
        return error_code_.sys;
      }

      inline void parser_base::
      sys_error (sys_error_t e)
      {
        error_type_ = error_sys;
        error_code_.sys = e;
      }
#endif // XSDE_EXCEPTIONS

#ifdef XSDE_VALIDATION
      inline parser_base::schema_error_t parser_base::
      schema_error () const
      {
        return error_code_.schema;
      }

      inline void parser_base::
      schema_error (schema_error_t e)
      {
        error_type_ = error_schema;
        error_code_.schema = e;
      }
#endif

#if defined(XSDE_VALIDATION) || !defined(XSDE_EXCEPTIONS)
      inline parser_base::
      parser_base ()
      {
        error_type_ = error_none;
        error_code_.memory = 0;
      }

      inline parser_base::error_type_t parser_base::
      error_type () const
      {
        return error_type_;
      }

      inline bool parser_base::
      error_p_ () const
      {
        return error_type_ != error_none;
      }

      inline void parser_base::
      copy_error_ (const parser_base* src)
      {
        error_type_ = src->error_type_;
        error_code_ = src->error_code_;
      }
#endif
    }
  }
}
