// Copyright (C) 2005-2007 Code Synthesis Tools CC
//
// This program was generated by CodeSynthesis XSD, an XML Schema to
// C++ data binding compiler.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// Furthermore, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include "library.hxx"

namespace library
{
  // isbn
  // 


  // title
  // 

  const title::lang_optional& title::
  lang () const
  {
    return this->lang_;
  }

  title::lang_optional& title::
  lang ()
  {
    return this->lang_;
  }

  void title::
  lang (const lang_type& lang)
  {
    this->lang_.set (lang);
  }

  void title::
  lang (const lang_optional& lang)
  {
    this->lang_ = lang;
  }

  void title::
  lang (::std::auto_ptr< lang_type > lang)
  {
    this->lang_.set (lang);
  }


  // genre
  // 

  genre::
  genre (value v)
  : ::xml_schema::string (_xsd_genre_literals_[v])
  {
  }

  genre::
  genre (const ::xml_schema::string& v)
  : ::xml_schema::string (v)
  {
  }

  genre::
  genre (const genre& v,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::string (v, f, c)
  {
  }

  genre& genre::
  operator= (value v)
  {
    static_cast< ::xml_schema::string& > (*this) = 
    ::xml_schema::string (_xsd_genre_literals_[v]);

    return *this;
  }


  // person
  // 

  const person::name_type& person::
  name () const
  {
    return this->name_.get ();
  }

  person::name_type& person::
  name ()
  {
    return this->name_.get ();
  }

  void person::
  name (const name_type& name)
  {
    this->name_.set (name);
  }

  void person::
  name (::std::auto_ptr< name_type > name)
  {
    this->name_.set (name);
  }

  const person::born_type& person::
  born () const
  {
    return this->born_.get ();
  }

  person::born_type& person::
  born ()
  {
    return this->born_.get ();
  }

  void person::
  born (const born_type& born)
  {
    this->born_.set (born);
  }

  void person::
  born (::std::auto_ptr< born_type > born)
  {
    this->born_.set (born);
  }

  const person::died_optional& person::
  died () const
  {
    return this->died_;
  }

  person::died_optional& person::
  died ()
  {
    return this->died_;
  }

  void person::
  died (const died_type& died)
  {
    this->died_.set (died);
  }

  void person::
  died (const died_optional& died)
  {
    this->died_ = died;
  }

  void person::
  died (::std::auto_ptr< died_type > died)
  {
    this->died_.set (died);
  }


  // author
  // 

  const author::recommends_optional& author::
  recommends () const
  {
    return this->recommends_;
  }

  author::recommends_optional& author::
  recommends ()
  {
    return this->recommends_;
  }

  void author::
  recommends (const recommends_type& recommends)
  {
    this->recommends_.set (recommends);
  }

  void author::
  recommends (const recommends_optional& recommends)
  {
    this->recommends_ = recommends;
  }

  void author::
  recommends (::std::auto_ptr< recommends_type > recommends)
  {
    this->recommends_.set (recommends);
  }


  // book
  // 

  const book::isbn_type& book::
  isbn () const
  {
    return this->isbn_.get ();
  }

  book::isbn_type& book::
  isbn ()
  {
    return this->isbn_.get ();
  }

  void book::
  isbn (const isbn_type& isbn)
  {
    this->isbn_.set (isbn);
  }

  void book::
  isbn (::std::auto_ptr< isbn_type > isbn)
  {
    this->isbn_.set (isbn);
  }

  const book::title_type& book::
  title () const
  {
    return this->title_.get ();
  }

  book::title_type& book::
  title ()
  {
    return this->title_.get ();
  }

  void book::
  title (const title_type& title)
  {
    this->title_.set (title);
  }

  void book::
  title (::std::auto_ptr< title_type > title)
  {
    this->title_.set (title);
  }

  const book::genre_type& book::
  genre () const
  {
    return this->genre_.get ();
  }

  book::genre_type& book::
  genre ()
  {
    return this->genre_.get ();
  }

  void book::
  genre (const genre_type& genre)
  {
    this->genre_.set (genre);
  }

  void book::
  genre (::std::auto_ptr< genre_type > genre)
  {
    this->genre_.set (genre);
  }

  const book::author_sequence& book::
  author () const
  {
    return this->author_;
  }

  book::author_sequence& book::
  author ()
  {
    return this->author_;
  }

  void book::
  author (const author_sequence& author)
  {
    this->author_ = author;
  }

  const book::available_type& book::
  available () const
  {
    return this->available_.get ();
  }

  book::available_type& book::
  available ()
  {
    return this->available_.get ();
  }

  void book::
  available (const available_type& available)
  {
    this->available_.set (available);
  }

  const book::available_type& book::
  available_default_value ()
  {
    return available_default_value_;
  }

  const book::id_type& book::
  id () const
  {
    return this->id_.get ();
  }

  book::id_type& book::
  id ()
  {
    return this->id_.get ();
  }

  void book::
  id (const id_type& id)
  {
    this->id_.set (id);
  }

  void book::
  id (::std::auto_ptr< id_type > id)
  {
    this->id_.set (id);
  }


  // catalog
  // 

  const catalog::book_sequence& catalog::
  book () const
  {
    return this->book_;
  }

  catalog::book_sequence& catalog::
  book ()
  {
    return this->book_;
  }

  void catalog::
  book (const book_sequence& book)
  {
    this->book_ = book;
  }
}

#include <xsd/cxx/xml/dom/parsing-source.hxx>

namespace library
{
  // isbn
  //

  isbn::
  isbn (const ::xml_schema::unsigned_int& unsignedInt)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type > (unsignedInt)
  {
  }

  isbn::
  isbn (const isbn& x,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type > (x, f, c)
  {
  }

  isbn::
  isbn (const ::xercesc::DOMElement& e,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type > (e, f, c)
  {
  }

  isbn::
  isbn (const ::xercesc::DOMAttr& a,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type > (a, f, c)
  {
  }

  isbn::
  isbn (const ::std::string& s,
        const ::xercesc::DOMElement* e,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type > (s, e, f, c)
  {
  }

  isbn* isbn::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new isbn (*this, f, c);
  }

  // title
  //

  title::
  title ()
  : ::xml_schema::string (),
    lang_ (::xml_schema::flags (), this)
  {
  }

  title::
  title (const ::xml_schema::string& string)
  : ::xml_schema::string (string),
    lang_ (::xml_schema::flags (), this)
  {
  }

  title::
  title (const title& x,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::string (x, f, c),
    lang_ (x.lang_, f, this)
  {
  }

  title::
  title (const ::xercesc::DOMElement& e,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::string (e, f | ::xml_schema::flags::base, c),
    lang_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void title::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "lang" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< lang_type > r (
          lang_traits::create (i, f, this));

        this->lang (r);
        continue;
      }
    }
  }

  title* title::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new title (*this, f, c);
  }

  // genre
  //

  genre::
  genre (const ::xercesc::DOMElement& e,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::string (e, f, c)
  {
    _xsd_genre_convert ();
  }

  genre::
  genre (const ::xercesc::DOMAttr& a,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::string (a, f, c)
  {
    _xsd_genre_convert ();
  }

  genre::
  genre (const ::std::string& s,
         const ::xercesc::DOMElement* e,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::string (s, e, f, c)
  {
    _xsd_genre_convert ();
  }

  genre* genre::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new genre (*this, f, c);
  }

  genre::value genre::
  _xsd_genre_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_genre_literals_);
    const value* i (::std::lower_bound (
                      _xsd_genre_indexes_,
                      _xsd_genre_indexes_ + 6,
                      *this,
                      c));

    if (i == _xsd_genre_indexes_ + 6 || _xsd_genre_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const genre::
  _xsd_genre_literals_[6] =
  {
    "romance",
    "fiction",
    "horror",
    "history",
    "philosophy",
    "reference"
  };

  const genre::value genre::
  _xsd_genre_indexes_[6] =
  {
    ::library::genre::fiction,
    ::library::genre::history,
    ::library::genre::horror,
    ::library::genre::philosophy,
    ::library::genre::reference,
    ::library::genre::romance
  };

  // person
  //

  person::
  person (const name_type& name,
          const born_type& born)
  : ::xml_schema::type (),
    name_ (name, ::xml_schema::flags (), this),
    born_ (born, ::xml_schema::flags (), this),
    died_ (::xml_schema::flags (), this)
  {
  }

  person::
  person (const person& x,
          ::xml_schema::flags f,
          ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    name_ (x.name_, f, this),
    born_ (x.born_, f, this),
    died_ (x.died_, f, this)
  {
  }

  person::
  person (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f,
          ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    name_ (f, this),
    born_ (f, this),
    died_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void person::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // name
      //
      if (n.name () == "name" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< name_type > r (
          name_traits::create (i, f, this));

        if (!name_.present ())
        {
          this->name (r);
          continue;
        }
      }

      // born
      //
      if (n.name () == "born" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< born_type > r (
          born_traits::create (i, f, this));

        if (!born_.present ())
        {
          this->born (r);
          continue;
        }
      }

      // died
      //
      if (n.name () == "died" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< died_type > r (
          died_traits::create (i, f, this));

        if (!this->died ())
        {
          this->died (r);
          continue;
        }
      }

      break;
    }

    if (!name_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "name",
        "");
    }

    if (!born_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "born",
        "");
    }
  }

  person* person::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new person (*this, f, c);
  }

  // author
  //

  author::
  author (const name_type& name,
          const born_type& born)
  : ::library::person (name,
                       born),
    recommends_ (::xml_schema::flags (), this)
  {
  }

  author::
  author (const author& x,
          ::xml_schema::flags f,
          ::xml_schema::type* c)
  : ::library::person (x, f, c),
    recommends_ (x.recommends_, f, this)
  {
  }

  author::
  author (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f,
          ::xml_schema::type* c)
  : ::library::person (e, f | ::xml_schema::flags::base, c),
    recommends_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void author::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    this->::library::person::parse (p, f);

    p.reset_attributes ();

    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "recommends" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< recommends_type > r (
          recommends_traits::create (i, f, this));

        this->recommends (r);
        continue;
      }
    }
  }

  author* author::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new author (*this, f, c);
  }

  // book
  //

  const book::available_type book::available_default_value_ (
    ::xsd::cxx::tree::traits< ::xml_schema::boolean, char >::create (
      ::std::string ("true"), 0, 0, 0));

  book::
  book (const isbn_type& isbn,
        const title_type& title,
        const genre_type& genre,
        const id_type& id)
  : ::xml_schema::type (),
    isbn_ (isbn, ::xml_schema::flags (), this),
    title_ (title, ::xml_schema::flags (), this),
    genre_ (genre, ::xml_schema::flags (), this),
    author_ (::xml_schema::flags (), this),
    available_ (available_default_value (), ::xml_schema::flags (), this),
    id_ (id, ::xml_schema::flags (), this)
  {
  }

  book::
  book (const book& x,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    isbn_ (x.isbn_, f, this),
    title_ (x.title_, f, this),
    genre_ (x.genre_, f, this),
    author_ (x.author_, f, this),
    available_ (x.available_, f, this),
    id_ (x.id_, f, this)
  {
  }

  book::
  book (const ::xercesc::DOMElement& e,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    isbn_ (f, this),
    title_ (f, this),
    genre_ (f, this),
    author_ (f, this),
    available_ (f, this),
    id_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void book::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // isbn
      //
      if (n.name () == "isbn" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< isbn_type > r (
          isbn_traits::create (i, f, this));

        if (!isbn_.present ())
        {
          this->isbn (r);
          continue;
        }
      }

      // title
      //
      if (n.name () == "title" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< title_type > r (
          title_traits::create (i, f, this));

        if (!title_.present ())
        {
          this->title (r);
          continue;
        }
      }

      // genre
      //
      if (n.name () == "genre" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< genre_type > r (
          genre_traits::create (i, f, this));

        if (!genre_.present ())
        {
          this->genre (r);
          continue;
        }
      }

      // author
      //
      if (n.name () == "author" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< author_type > r (
          author_traits::create (i, f, this));

        this->author ().push_back (r);
        continue;
      }

      break;
    }

    if (!isbn_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "isbn",
        "");
    }

    if (!title_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "title",
        "");
    }

    if (!genre_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "genre",
        "");
    }

    while (p.more_attributes ())
    {
      const ::xercesc::DOMAttr& i (p.next_attribute ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      if (n.name () == "available" && n.namespace_ ().empty ())
      {
        this->available (available_traits::create (i, f, this));
        continue;
      }

      if (n.name () == "id" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< id_type > r (
          id_traits::create (i, f, this));

        this->id (r);
        continue;
      }
    }

    if (!available_.present ())
    {
      this->available (
        available_traits::create (
          ::std::string ("true"),
          &p.element (), f, this));
    }

    if (!id_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "id",
        "");
    }
  }

  book* book::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new book (*this, f, c);
  }

  // catalog
  //

  catalog::
  catalog ()
  : ::xml_schema::type (),
    book_ (::xml_schema::flags (), this)
  {
  }

  catalog::
  catalog (const catalog& x,
           ::xml_schema::flags f,
           ::xml_schema::type* c)
  : ::xml_schema::type (x, f, c),
    book_ (x.book_, f, this)
  {
  }

  catalog::
  catalog (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f,
           ::xml_schema::type* c)
  : ::xml_schema::type (e, f | ::xml_schema::flags::base, c),
    book_ (f, this)
  {
    if ((f & ::xml_schema::flags::base) == 0)
    {
      ::xsd::cxx::xml::dom::parser< char > p (e);
      this->parse (p, f);
    }
  }

  void catalog::
  parse (::xsd::cxx::xml::dom::parser< char >& p,
         ::xml_schema::flags f)
  {
    for (; p.more_elements (); p.next_element ())
    {
      const ::xercesc::DOMElement& i (p.cur_element ());
      const ::xsd::cxx::xml::qualified_name< char > n (
        ::xsd::cxx::xml::dom::name< char > (i));

      // book
      //
      if (n.name () == "book" && n.namespace_ ().empty ())
      {
        ::std::auto_ptr< book_type > r (
          book_traits::create (i, f, this));

        this->book ().push_back (r);
        continue;
      }

      break;
    }
  }

  catalog* catalog::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new catalog (*this, f, c);
  }
}

#include <ostream>

namespace library
{
  ::std::ostream&
  operator<< (::std::ostream& o, const isbn& i)
  {
    o << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type >& > (i);
    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const title& i)
  {
    o << static_cast< const ::xml_schema::string& > (i);
    if (i.lang ())
    {
      o << ::std::endl << "lang: " << *i.lang ();
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, genre::value i)
  {
    return o << genre::_xsd_genre_literals_[i];
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const genre& i)
  {
    return o << static_cast< const ::xml_schema::string& > (i);
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const person& i)
  {
    o << ::std::endl << "name: " << i.name ();
    o << ::std::endl << "born: " << i.born ();
    if (i.died ())
    {
      o << ::std::endl << "died: " << *i.died ();
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const author& i)
  {
    o << static_cast< const ::library::person& > (i);
    if (i.recommends ())
    {
      o << ::std::endl << "recommends: " << *i.recommends ();
    }

    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const book& i)
  {
    o << ::std::endl << "isbn: " << i.isbn ();
    o << ::std::endl << "title: " << i.title ();
    o << ::std::endl << "genre: " << i.genre ();
    for (book::author_const_iterator
         b (i.author ().begin ()), e (i.author ().end ());
         b != e; ++b)
    {
      o << ::std::endl << "author: " << *b;
    }

    o << ::std::endl << "available: " << i.available ();
    o << ::std::endl << "id: " << i.id ();
    return o;
  }

  ::std::ostream&
  operator<< (::std::ostream& o, const catalog& i)
  {
    for (catalog::book_const_iterator
         b (i.book ().begin ()), e (i.book ().end ());
         b != e; ++b)
    {
      o << ::std::endl << "book: " << *b;
    }

    return o;
  }
}

#include <istream>
#include <xercesc/framework/Wrapper4InputSource.hpp>
#include <xsd/cxx/xml/sax/std-input-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace library
{
  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::std::string& u,
            ::xml_schema::flags f,
            const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    ::std::auto_ptr< ::library::catalog > r (
      ::library::catalog_ (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::std::string& u,
            ::xml_schema::error_handler& h,
            ::xml_schema::flags f,
            const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

    if (!d)
      throw ::xsd::cxx::tree::parsing< char > ();

    ::std::auto_ptr< ::library::catalog > r (
      ::library::catalog_ (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::std::string& u,
            ::xercesc::DOMErrorHandler& h,
            ::xml_schema::flags f,
            const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

    if (!d)
      throw ::xsd::cxx::tree::parsing< char > ();

    ::std::auto_ptr< ::library::catalog > r (
      ::library::catalog_ (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream& is,
            ::xml_schema::flags f,
            const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::library::catalog_ (wrap, f, p);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream& is,
            ::xml_schema::error_handler& h,
            ::xml_schema::flags f,
            const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::library::catalog_ (wrap, h, f, p);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream& is,
            ::xercesc::DOMErrorHandler& h,
            ::xml_schema::flags f,
            const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::library::catalog_ (wrap, h, f, p);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream& is,
            const ::std::string& sid,
            ::xml_schema::flags f,
            const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::library::catalog_ (wrap, f, p);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream& is,
            const ::std::string& sid,
            ::xml_schema::error_handler& h,
            ::xml_schema::flags f,
            const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::library::catalog_ (wrap, h, f, p);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream& is,
            const ::std::string& sid,
            ::xercesc::DOMErrorHandler& h,
            ::xml_schema::flags f,
            const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::library::catalog_ (wrap, h, f, p);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::xercesc::DOMInputSource& i,
            ::xml_schema::flags f,
            const ::xml_schema::properties& p)
  {
    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    ::std::auto_ptr< ::library::catalog > r (
      ::library::catalog_ (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::xercesc::DOMInputSource& i,
            ::xml_schema::error_handler& h,
            ::xml_schema::flags f,
            const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

    if (!d)
      throw ::xsd::cxx::tree::parsing< char > ();

    ::std::auto_ptr< ::library::catalog > r (
      ::library::catalog_ (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::xercesc::DOMInputSource& i,
            ::xercesc::DOMErrorHandler& h,
            ::xml_schema::flags f,
            const ::xml_schema::properties& p)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

    if (!d)
      throw ::xsd::cxx::tree::parsing< char > ();

    ::std::auto_ptr< ::library::catalog > r (
      ::library::catalog_ (
        d.get (), f | ::xml_schema::flags::own_dom, p));

    if (f & ::xml_schema::flags::keep_dom)
      d.release ();

    return r;
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::xercesc::DOMDocument& d,
            ::xml_schema::flags f,
            const ::xml_schema::properties& p)
  {
    if (f & ::xml_schema::flags::keep_dom)
    {
      ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > c (
        static_cast< ::xercesc::DOMDocument* > (d.cloneNode (true)));

      ::std::auto_ptr< ::library::catalog > r (
        ::library::catalog_ (
          c.get (), f | ::xml_schema::flags::own_dom, p));

      c.release ();
      return r;
    }

    const ::xercesc::DOMElement& e (*d.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "catalog" &&
        n.namespace_ () == "http://www.codesynthesis.com/library")
    {
      ::std::auto_ptr< ::library::catalog > r (
        ::xsd::cxx::tree::traits< ::library::catalog, char >::create (
          e, f, 0));
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "catalog",
      "http://www.codesynthesis.com/library");
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::xercesc::DOMDocument* d,
            ::xml_schema::flags f,
            const ::xml_schema::properties&)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > c (
      ((f & ::xml_schema::flags::keep_dom) &&
       !(f & ::xml_schema::flags::own_dom))
      ? static_cast< ::xercesc::DOMDocument* > (d->cloneNode (true))
      : 0);

    const ::xercesc::DOMElement& e (
      c.get ()
      ? *c->getDocumentElement ()
      : *d->getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "catalog" &&
        n.namespace_ () == "http://www.codesynthesis.com/library")
    {
      ::std::auto_ptr< ::library::catalog > r (
        ::xsd::cxx::tree::traits< ::library::catalog, char >::create (
          e, f, 0));
      c.release ();
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      n.name (),
      n.namespace_ (),
      "catalog",
      "http://www.codesynthesis.com/library");
  }
}

#include <ostream>
#include <xsd/cxx/xml/dom/serialization-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace library
{
  void
  operator<< (::xercesc::DOMElement& e, const isbn& i)
  {
    e << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a,const isbn& i)
  {
    a << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xsd::cxx::tree::list_stream< char >& l,
              const isbn& i)
  {
    l << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const title& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);

    // lang
    //
    if (i.lang ())
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "lang",
          e));

      a << *i.lang ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const genre& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a, const genre& i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xsd::cxx::tree::list_stream< char >& l,
              const genre& i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e, const person& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // name
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "name",
          e));

      s << i.name ();
    }

    // born
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "born",
          e));

      s << i.born ();
    }

    // died
    //
    if (i.died ())
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "died",
          e));

      s << *i.died ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const author& i)
  {
    e << static_cast< const ::library::person& > (i);

    // recommends
    //
    if (i.recommends ())
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "recommends",
          e));

      a << *i.recommends ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const book& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // isbn
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "isbn",
          e));

      s << i.isbn ();
    }

    // title
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "title",
          e));

      s << i.title ();
    }

    // genre
    //
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "genre",
          e));

      s << i.genre ();
    }

    // author
    //
    for (book::author_const_iterator
         b (i.author ().begin ()), n (i.author ().end ());
         b != n; ++b)
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "author",
          e));

      s << *b;
    }

    // available
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "available",
          e));

      a << i.available ();
    }

    // id
    //
    {
      ::xercesc::DOMAttr& a (
        ::xsd::cxx::xml::dom::create_attribute (
          "id",
          e));

      a << i.id ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e, const catalog& i)
  {
    e << static_cast< const ::xml_schema::type& > (i);

    // book
    //
    for (catalog::book_const_iterator
         b (i.book ().begin ()), n (i.book ().end ());
         b != n; ++b)
    {
      ::xercesc::DOMElement& s (
        ::xsd::cxx::xml::dom::create_element (
          "book",
          e));

      s << *b;
    }
  }

  void
  catalog_ (::std::ostream& o,
            const ::library::catalog& s,
            const ::xml_schema::namespace_infomap& m,
            const ::std::string& e,
            ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::library::catalog_ (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  catalog_ (::std::ostream& o,
            const ::library::catalog& s,
            const ::xml_schema::namespace_infomap& m,
            ::xml_schema::error_handler& h,
            const ::std::string& e,
            ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::library::catalog_ (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  catalog_ (::std::ostream& o,
            const ::library::catalog& s,
            const ::xml_schema::namespace_infomap& m,
            ::xercesc::DOMErrorHandler& h,
            const ::std::string& e,
            ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::library::catalog_ (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  catalog_ (::xercesc::XMLFormatTarget& t,
            const ::library::catalog& s,
            const ::xml_schema::namespace_infomap& m,
            const ::std::string& e,
            ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::library::catalog_ (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  catalog_ (::xercesc::XMLFormatTarget& t,
            const ::library::catalog& s,
            const ::xml_schema::namespace_infomap& m,
            ::xml_schema::error_handler& h,
            const ::std::string& e,
            ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::library::catalog_ (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  catalog_ (::xercesc::XMLFormatTarget& t,
            const ::library::catalog& s,
            const ::xml_schema::namespace_infomap& m,
            ::xercesc::DOMErrorHandler& h,
            const ::std::string& e,
            ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::library::catalog_ (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  catalog_ (::xercesc::DOMDocument& d,
            const ::library::catalog& s,
            ::xml_schema::flags)
  {
    ::xercesc::DOMElement& e (*d.getDocumentElement ());
    const ::xsd::cxx::xml::qualified_name< char > n (
      ::xsd::cxx::xml::dom::name< char > (e));

    if (n.name () == "catalog" &&
        n.namespace_ () == "http://www.codesynthesis.com/library")
    {
      e << s;
    }
    else
    {
      throw ::xsd::cxx::tree::unexpected_element < char > (
        n.name (),
        n.namespace_ (),
        "catalog",
        "http://www.codesynthesis.com/library");
    }
  }

  ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument >
  catalog_ (const ::library::catalog& s,
            const ::xml_schema::namespace_infomap& m,
            ::xml_schema::flags f)
  {
    try
    {
      ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
        ::xsd::cxx::xml::dom::serialize< char > (
          "catalog",
          "http://www.codesynthesis.com/library",
          m, f));

      ::library::catalog_ (*d, s, f);
      return d;
    }
    catch (const ::xsd::cxx::xml::dom::mapping< char >& e)
    {
      throw ::xsd::cxx::tree::no_namespace_mapping< char > (e.name ());
    }
    catch (const ::xsd::cxx::xml::dom::xsi_already_in_use&)
    {
      throw ::xsd::cxx::tree::xsi_already_in_use< char > ();
    }
  }
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

