# file      : examples/build/cxx/rules.make
# author    : Boris Kolpackov <boris@codesynthesis.com>
# copyright : Copyright (c) 2006 Code Synthesis Tools CC
# license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

include $(root)/build/cxx/compilers.make


# GNU g++
#
ifeq ($(cxx_id),gnu)
  CXXFLAGS := -W -Wall
endif


# Intel C++
#
ifeq ($(cxx_id),intel)
  CXXFLAGS := -w1 -O0
endif


# Sun C++
#
ifeq ($(cxx_id),sun)
endif


# HP aCC3
#
ifeq ($(cxx_id),hp3)

  # 849 : symbol to long, truncated to 4000
  # 1039: incompatible vtable layout

  CXXFLAGS := -AA +W849 +W1039
endif


# HP aCC6
#
ifeq ($(cxx_id),hp6)

  # 2334: no suitable copy constructor
  # 2340: value copied to temporary, reference is used

  CXXFLAGS := -Aa +W2334 +W2340
endif


# IBM XL C++
#
ifeq ($(cxx_id),ibm)
endif


# Rules.
#
%.o: %.cxx
	$(CXX) $(CPPFLAGS) $(CXXFLAGS) -c $< -o $@

%: %.o
	$(CXX) $(CXXFLAGS) $(LDFLAGS) -o $@ $^ $(LIBS)
