// file      : examples/cxx/tree/custom/calendar/xml-schema-custom.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : not copyrighted - public domain

// Include xml-schema.hxx instead of xml-schema-custom.hxx here.
//
#include "xml-schema.hxx"

#include <xsd/cxx/xml/string.hxx> // xml::transcode

using namespace boost;
using namespace boost::gregorian;
namespace xml = xsd::cxx::xml;

namespace xml_schema
{
  date::
  date (const xercesc::DOMElement& e, flags f, type* container)
      : simple_type (e, f, container),
        gregorian::date (
          from_simple_string (
            xml::transcode<char> (e.getTextContent ())))
  {
  }

  date::
  date (const xercesc::DOMAttr& a, flags f, type* container)
      : simple_type (a, f, container),
        gregorian::date (
          from_simple_string (
            xml::transcode<char> (a.getValue ())))
  {
  }

  date::
  date (const date& d, flags f, type* container)
      : simple_type (d, f, container),
        gregorian::date (d)
  {
  }

  date* date::
  _clone (flags f, type* container) const
  {
    return new date (*this, f, container);
  }
}
