// file      : examples/cxx/parser/hello/driver.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : not copyrighted - public domain

#include <string>
#include <iostream>

#include "hello.hxx"

using std::cerr;
using std::endl;
using std::string;


struct hello_parser: hello_type<void,
                                string, // greeting
                                string> // name
{
  virtual void
  greeting (const string& greeting)
  {
    greeting_ = greeting;
  }

  virtual void
  name (const string& name)
  {
    cerr << greeting_ << ", " << name << "!" << endl;
  }

private:
  string greeting_;
};


int
main (int argc, char* argv[])
{
  if (argc != 2)
  {
    cerr << "usage: " << argv[0] << " hello.xml" << endl;
    return 1;
  }

  try
  {
    // Construct the parser.
    //
    xml_schema::string string_p;
    hello_parser hello_p;

    hello_p.greeting_parser (string_p);
    hello_p.name_parser (string_p);


    // Parse the XML instance document. The second argument to the
    // document's constructor is the document's root element name.
    //
    xml_schema::document<void> doc_p (hello_p, "hello");

    doc_p.parse (argv[1]);
  }
  catch (const xml_schema::exception& e)
  {
    cerr << e << endl;
    return 1;
  }
  catch (const std::ios_base::failure&)
  {
    cerr << "io failure" << endl;
    return 1;
  }
}
