// Copyright (C) 2005-2007 Code Synthesis Tools CC
//
// This program was generated by XML Schema Definition Compiler (XSD)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// Furthermore, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

#ifndef LIBRARY_HXX
#define LIBRARY_HXX

#include <xsd/cxx/version.hxx>

#if (XSD_INT_VERSION != 2030100L)
#error XSD runtime version mismatch
#endif

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>
#include <xsd/cxx/xml/error-handler.hxx>

#include <xsd/cxx/tree/parsing.hxx>

#include <xsd/cxx/tree/serialization.hxx>
#include <xsd/cxx/xml/dom/namespace-infomap.hxx>

#include <xsd/cxx/tree/std-ostream-operators.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type<type> simple_type;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef integer non_positive_integer;
  typedef integer non_negative_integer;
  typedef integer positive_integer;
  typedef integer negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef long double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char, simple_type > string;
  typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
  typedef ::xsd::cxx::tree::token< char, normalized_string > token;
  typedef ::xsd::cxx::tree::name< char, token > name;
  typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken> nmtokens;
  typedef ::xsd::cxx::tree::ncname< char, name > ncname;
  typedef ::xsd::cxx::tree::language< char, token > language;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char, ncname > id;
  typedef ::xsd::cxx::tree::idref< type, char, ncname > idref;
  typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::date< char, simple_type > date;
  typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
  typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
  typedef ::xsd::cxx::tree::day< char, simple_type > day;
  typedef ::xsd::cxx::tree::month< char, simple_type > month;
  typedef ::xsd::cxx::tree::month_day< char, simple_type > month_day;
  typedef ::xsd::cxx::tree::year< char, simple_type > year;
  typedef ::xsd::cxx::tree::year_month< char, simple_type > year_month;
  typedef ::xsd::cxx::tree::time< char, simple_type > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char, ncname > entity;
  typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::expected_text_content< char > expected_text_content;
  typedef ::xsd::cxx::tree::no_type_info< char > no_type_info;
  typedef ::xsd::cxx::tree::not_derived< char > not_derived;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::serialization< char > serialization;
  typedef ::xsd::cxx::tree::no_namespace_mapping< char > no_namespace_mapping;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::xsi_already_in_use< char > xsi_already_in_use;
  typedef ::xsd::cxx::tree::bounds< char > bounds;

  // Parsing/serialization error.
  //
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::errors< char > errors;

  // Error handler interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;

  // Namespace information. Used in serialization functions.
  //
  typedef ::xsd::cxx::xml::dom::namespace_info < char > namespace_info;
  typedef ::xsd::cxx::xml::dom::namespace_infomap < char > namespace_infomap;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // DOM user data key for back pointers to tree nodes.
  //
#ifndef XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA

  const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;

#endif
}

// Forward declarations.
//
namespace library
{
  class isbn;
  class title;
  class genre;
  class person;
  class author;
  class book;
  class catalog;
}


#include <memory>    // std::auto_ptr
#include <algorithm> // std::binary_search

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

namespace library
{
  class isbn: public ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type >
  {
    public:

    struct _xsd_isbn
    {
      typedef ::xml_schema::unsigned_int base_;
    };

    // Constructors.
    //
    public:
    isbn (const _xsd_isbn::base_& );

    isbn (const ::xercesc::DOMElement&,
          ::xml_schema::flags = 0,
          ::xml_schema::type* = 0);

    isbn (const ::xercesc::DOMAttr&,
          ::xml_schema::flags = 0,
          ::xml_schema::type* = 0);

    isbn (const ::std::basic_string< char >&,
          const ::xercesc::DOMElement*,
          ::xml_schema::flags = 0,
          ::xml_schema::type* = 0);

    isbn (const isbn&,
          ::xml_schema::flags = 0,
          ::xml_schema::type* = 0);

    virtual isbn*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;
  };

  class title: public ::xml_schema::string
  {
    public:

    struct _xsd_title
    {
      typedef ::xml_schema::string base_;
    };

    // lang
    // 
    public:
    struct lang
    {
      typedef ::xml_schema::language type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const lang::container&
    lang () const;

    lang::container&
    lang ();

    void
    lang (const lang::type&);

    void
    lang (const lang::container&);

    void
    lang (::std::auto_ptr< lang::type >);

    // Constructors.
    //
    public:
    title (const _xsd_title::base_& );

    title (const ::xercesc::DOMElement&,
           ::xml_schema::flags = 0,
           ::xml_schema::type* = 0);

    title (const title&,
           ::xml_schema::flags = 0,
           ::xml_schema::type* = 0);

    virtual title*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::optional< lang::type > _xsd_lang_;
  };

  class genre: public ::xml_schema::string
  {
    public:
    enum _xsd_genre
    {
      romance,
      fiction,
      horror,
      history,
      philosophy,
      reference
    };

    genre (_xsd_genre);

    genre (const ::xml_schema::string&);

    genre (const ::xercesc::DOMElement&,
           ::xml_schema::flags = 0,
           ::xml_schema::type* = 0);

    genre (const ::xercesc::DOMAttr&,
           ::xml_schema::flags = 0,
           ::xml_schema::type* = 0);

    genre (const ::std::basic_string< char >&,
           const ::xercesc::DOMElement*,
           ::xml_schema::flags = 0,
           ::xml_schema::type* = 0);

    genre (const genre&,
           ::xml_schema::flags = 0,
           ::xml_schema::type* = 0);

    virtual genre*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    genre&
    operator= (_xsd_genre);

    virtual
    operator _xsd_genre () const
    {
      return _xsd_genre_convert ();
    }

    protected:
    _xsd_genre
    _xsd_genre_convert () const;

    public:
    static const char* const _xsd_genre_literals_[6];
    static const _xsd_genre _xsd_genre_indexes_[6];
  };

  class person: public ::xml_schema::type
  {
    public:

    struct _xsd_person
    {
      typedef ::xml_schema::type base_;
    };

    // name
    // 
    public:
    struct name
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const name::type&
    name () const;

    name::type&
    name ();

    void
    name (const name::type&);

    void
    name (::std::auto_ptr< name::type >);

    // born
    // 
    public:
    struct born
    {
      typedef ::xml_schema::date type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const born::type&
    born () const;

    born::type&
    born ();

    void
    born (const born::type&);

    void
    born (::std::auto_ptr< born::type >);

    // died
    // 
    public:
    struct died
    {
      typedef ::xml_schema::date type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const died::container&
    died () const;

    died::container&
    died ();

    void
    died (const died::type&);

    void
    died (const died::container&);

    void
    died (::std::auto_ptr< died::type >);

    // Constructors.
    //
    public:
    person (const name::type&,
            const born::type&);

    person (const ::xercesc::DOMElement&,
            ::xml_schema::flags = 0,
            ::xml_schema::type* = 0);

    person (const person&,
            ::xml_schema::flags = 0,
            ::xml_schema::type* = 0);

    virtual person*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< name::type > _xsd_name_;
    ::xsd::cxx::tree::one< born::type > _xsd_born_;
    ::xsd::cxx::tree::optional< died::type > _xsd_died_;
  };

  class author: public ::library::person
  {
    public:

    struct _xsd_author
    {
      typedef ::library::person base_;
    };

    // recommends
    // 
    public:
    struct recommends
    {
      struct _xsd_recommends_
      {
        typedef ::xsd::cxx::tree::idref< ::library::book, char, ::xml_schema::ncname > recommends;
      };

      typedef _xsd_recommends_::recommends type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const recommends::container&
    recommends () const;

    recommends::container&
    recommends ();

    void
    recommends (const recommends::type&);

    void
    recommends (const recommends::container&);

    void
    recommends (::std::auto_ptr< recommends::type >);

#if defined(__EDG_VERSION__) || (defined(__HP_aCC) && __HP_aCC >= 60000)
    public:
    using _xsd_author::base_::name;
    using _xsd_author::base_::born;
#endif

    // Constructors.
    //
    public:
    author (const name::type&,
            const born::type&);

    author (const ::xercesc::DOMElement&,
            ::xml_schema::flags = 0,
            ::xml_schema::type* = 0);

    author (const author&,
            ::xml_schema::flags = 0,
            ::xml_schema::type* = 0);

    virtual author*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::optional< recommends::type > _xsd_recommends_;
  };

  class book: public ::xml_schema::type
  {
    public:

    struct _xsd_book
    {
      typedef ::xml_schema::type base_;
    };

    // isbn
    // 
    public:
    struct isbn
    {
      typedef ::library::isbn type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const isbn::type&
    isbn () const;

    isbn::type&
    isbn ();

    void
    isbn (const isbn::type&);

    void
    isbn (::std::auto_ptr< isbn::type >);

    // title
    // 
    public:
    struct title
    {
      typedef ::library::title type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const title::type&
    title () const;

    title::type&
    title ();

    void
    title (const title::type&);

    void
    title (::std::auto_ptr< title::type >);

    // genre
    // 
    public:
    struct genre
    {
      typedef ::library::genre type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const genre::type&
    genre () const;

    genre::type&
    genre ();

    void
    genre (const genre::type&);

    void
    genre (::std::auto_ptr< genre::type >);

    // author
    // 
    public:
    struct author
    {
      typedef ::library::author type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::sequence< type > container;
      typedef container::iterator iterator;
      typedef container::const_iterator const_iterator;
    };

    const author::container&
    author () const;

    author::container&
    author ();

    void
    author (const author::container&);

    // available
    // 
    public:
    struct available
    {
      typedef ::xml_schema::boolean type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;

      static const type&
      default_value ();

      private:
      static const type default_value_;
    };

    const available::type&
    available () const;

    available::type&
    available ();

    void
    available (const available::type&);

    // id
    // 
    public:
    struct id
    {
      typedef ::xml_schema::id type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const id::type&
    id () const;

    id::type&
    id ();

    void
    id (const id::type&);

    void
    id (::std::auto_ptr< id::type >);

    // Constructors.
    //
    public:
    book (const isbn::type&,
          const title::type&,
          const genre::type&,
          const id::type&);

    book (const ::xercesc::DOMElement&,
          ::xml_schema::flags = 0,
          ::xml_schema::type* = 0);

    book (const book&,
          ::xml_schema::flags = 0,
          ::xml_schema::type* = 0);

    virtual book*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< isbn::type > _xsd_isbn_;
    ::xsd::cxx::tree::one< title::type > _xsd_title_;
    ::xsd::cxx::tree::one< genre::type > _xsd_genre_;
    ::xsd::cxx::tree::sequence< author::type > _xsd_author_;
    ::xsd::cxx::tree::one< available::type > _xsd_available_;
    ::xsd::cxx::tree::one< id::type > _xsd_id_;
  };

  class catalog: public ::xml_schema::type
  {
    public:

    struct _xsd_catalog
    {
      typedef ::xml_schema::type base_;
    };

    // book
    // 
    public:
    struct book
    {
      typedef ::library::book type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::sequence< type > container;
      typedef container::iterator iterator;
      typedef container::const_iterator const_iterator;
    };

    const book::container&
    book () const;

    book::container&
    book ();

    void
    book (const book::container&);

    // Constructors.
    //
    public:
    catalog ();

    catalog (const ::xercesc::DOMElement&,
             ::xml_schema::flags = 0,
             ::xml_schema::type* = 0);

    catalog (const catalog&,
             ::xml_schema::flags = 0,
             ::xml_schema::type* = 0);

    virtual catalog*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::sequence< book::type > _xsd_book_;
  };
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMInputSource.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

namespace library
{
  // Read from a URI or a local file.
  //

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::std::basic_string< char >&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::std::basic_string< char >&,
            ::xsd::cxx::xml::error_handler< char >&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::std::basic_string< char >&,
            ::xercesc::DOMErrorHandler&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  // Read from std::istream.
  //

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream&,
            ::xsd::cxx::xml::error_handler< char >&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream&,
            ::xercesc::DOMErrorHandler&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream&,
            const ::std::basic_string< char >& id,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream&,
            const ::std::basic_string< char >& id,
            ::xsd::cxx::xml::error_handler< char >&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream&,
            const ::std::basic_string< char >& id,
            ::xercesc::DOMErrorHandler&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  // Read from InputSource.
  //

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::xercesc::DOMInputSource&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::xercesc::DOMInputSource&,
            ::xsd::cxx::xml::error_handler< char >&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::xercesc::DOMInputSource&,
            ::xercesc::DOMErrorHandler&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  // Read from DOM.
  //

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::xercesc::DOMDocument&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());
}

#include <iosfwd> // std::basic_ostream&

namespace library
{
  ::std::basic_ostream< char >&
  operator<< (::std::basic_ostream< char >&,
              const isbn&);

  ::std::basic_ostream< char >&
  operator<< (::std::basic_ostream< char >&,
              const title&);

  ::std::basic_ostream< char >&
  operator<< (::std::basic_ostream< char >&,
              genre::_xsd_genre);

  ::std::basic_ostream< char >&
  operator<< (::std::basic_ostream< char >&,
              genre);

  ::std::basic_ostream< char >&
  operator<< (::std::basic_ostream< char >&,
              const person&);

  ::std::basic_ostream< char >&
  operator<< (::std::basic_ostream< char >&,
              const author&);

  ::std::basic_ostream< char >&
  operator<< (::std::basic_ostream< char >&,
              const book&);

  ::std::basic_ostream< char >&
  operator<< (::std::basic_ostream< char >&,
              const catalog&);
}

#include <iosfwd> // std::ostream&

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/framework/XMLFormatter.hpp>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

namespace library
{
  void
  operator<< (::xercesc::DOMElement&,
              const isbn&);

  void
  operator<< (::xercesc::DOMAttr&,
              const isbn&);

  void
  operator<< (::xsd::cxx::tree::list_stream< char >&,
              const isbn&);

  void
  operator<< (::xercesc::DOMElement&,
              const title&);

  void
  operator<< (::xercesc::DOMElement&,
              genre);

  void
  operator<< (::xercesc::DOMAttr&,
              genre);

  void
  operator<< (::xsd::cxx::tree::list_stream< char >&,
              genre);

  void
  operator<< (::xercesc::DOMElement&,
              const person&);

  void
  operator<< (::xercesc::DOMElement&,
              const author&);

  void
  operator<< (::xercesc::DOMElement&,
              const book&);

  void
  operator<< (::xercesc::DOMElement&,
              const catalog&);

  // Serialize to an existing DOM instance.
  //
  void
  catalog_ (::xercesc::DOMDocument&,
            const ::library::catalog&,
            ::xml_schema::flags = 0);


  // Serialize to a new DOM instance.
  //
  ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument >
  catalog_ (const ::library::catalog&, 
            const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
            ::xml_schema::flags = 0);


  // Serialize to XMLFormatTarget.
  //
  void
  catalog_ (::xercesc::XMLFormatTarget&,
            const ::library::catalog&, 
            const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
            const ::std::basic_string< char >& = "UTF-8",
            ::xml_schema::flags = 0);


  void
  catalog_ (::xercesc::XMLFormatTarget&,
            const ::library::catalog&, 
            const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
            ::xsd::cxx::xml::error_handler< char >&,
            const ::std::basic_string< char >& = "UTF-8",
            ::xml_schema::flags = 0);

  void
  catalog_ (::xercesc::XMLFormatTarget&,
            const ::library::catalog&, 
            const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
            ::xercesc::DOMErrorHandler&,
            const ::std::basic_string< char >& = "UTF-8",
            ::xml_schema::flags = 0);


  // Serialize to std::ostream.
  //
  void
  catalog_ (::std::ostream&,
            const ::library::catalog&, 
            const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
            const ::std::basic_string< char >& = "UTF-8",
            ::xml_schema::flags = 0);


  void
  catalog_ (::std::ostream&,
            const ::library::catalog&, 
            const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
            ::xsd::cxx::xml::error_handler< char >&,
            const ::std::basic_string< char >& = "UTF-8",
            ::xml_schema::flags = 0);

  void
  catalog_ (::std::ostream&,
            const ::library::catalog&, 
            const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
            ::xercesc::DOMErrorHandler&,
            const ::std::basic_string< char >& = "UTF-8",
            ::xml_schema::flags = 0);
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

#endif // LIBRARY_HXX
