// file      : examples/cxx/tree/custom/contacts/contacts-custom.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : not copyrighted - public domain

#include <ostream>

// Include contacts.hxx instead of contacts-custom.hxx here.
//
#include "contacts.hxx"

namespace contacts
{
  // We implement the following constructs by simply forwarding
  // to our base.
  //
  contact::
  contact (const name::type& n,
           const email::type& e,
           const phone::type& p)
      : contact_base (n, e, p)
  {
  }


  contact::
  contact (const xercesc::DOMElement& e,
           xml_schema::flags f,
           xml_schema::type* container)
      : contact_base (e, f, container)
  {
  }

  contact::
  contact (const contact& c,
           xml_schema::flags f,
           xml_schema::type* container)
      : contact_base (c, f, container)
  {
  }

  contact* contact::
  _clone (xml_schema::flags f,
          xml_schema::type* container) const
  {
    return new contact (*this, f, container);
  }

  void contact::
  print (std::ostream& os) const
  {
    os << name () << " e| " << email () << " t| " << phone () << std::endl;
  }
}
