// Copyright (C) 2005-2007 Code Synthesis Tools CC
//
// This program was generated by XML Schema Definition Compiler (XSD)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// Furthermore, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#include "library.hxx"

namespace library
{
  // isbn
  // 


  // title
  // 

  const title::lang::container& title::
  lang () const
  {
    return this->_xsd_lang_;
  }

  title::lang::container& title::
  lang ()
  {
    return this->_xsd_lang_;
  }

  void title::
  lang (const lang::type& lang)
  {
    this->_xsd_lang_.set (lang);
  }

  void title::
  lang (const lang::container& lang)
  {
    this->_xsd_lang_ = lang;
  }

  void title::
  lang (::std::auto_ptr< lang::type > lang)
  {
    this->_xsd_lang_.set (lang);
  }


  // genre
  // 

  genre::
  genre (_xsd_genre v)
  : ::xml_schema::string (_xsd_genre_literals_[v])
  {
  }

  genre::
  genre (const ::xml_schema::string& _xsd_genre)
  : ::xml_schema::string (_xsd_genre)
  {
  }

  genre::
  genre (const genre& v,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::string (v, f, c)
  {
  }

  genre& genre::
  operator= (_xsd_genre v)
  {
    static_cast< ::xml_schema::string& > (*this) = 
    ::xml_schema::string (_xsd_genre_literals_[v]);

    return *this;
  }


  // person
  // 

  const person::name::type& person::
  name () const
  {
    return this->_xsd_name_.get ();
  }

  person::name::type& person::
  name ()
  {
    return this->_xsd_name_.get ();
  }

  void person::
  name (const name::type& name)
  {
    this->_xsd_name_.set (name);
  }

  void person::
  name (::std::auto_ptr< name::type > name)
  {
    this->_xsd_name_.set (name);
  }

  const person::born::type& person::
  born () const
  {
    return this->_xsd_born_.get ();
  }

  person::born::type& person::
  born ()
  {
    return this->_xsd_born_.get ();
  }

  void person::
  born (const born::type& born)
  {
    this->_xsd_born_.set (born);
  }

  void person::
  born (::std::auto_ptr< born::type > born)
  {
    this->_xsd_born_.set (born);
  }

  const person::died::container& person::
  died () const
  {
    return this->_xsd_died_;
  }

  person::died::container& person::
  died ()
  {
    return this->_xsd_died_;
  }

  void person::
  died (const died::type& died)
  {
    this->_xsd_died_.set (died);
  }

  void person::
  died (const died::container& died)
  {
    this->_xsd_died_ = died;
  }

  void person::
  died (::std::auto_ptr< died::type > died)
  {
    this->_xsd_died_.set (died);
  }


  // author
  // 

  const author::recommends::container& author::
  recommends () const
  {
    return this->_xsd_recommends_;
  }

  author::recommends::container& author::
  recommends ()
  {
    return this->_xsd_recommends_;
  }

  void author::
  recommends (const recommends::type& recommends)
  {
    this->_xsd_recommends_.set (recommends);
  }

  void author::
  recommends (const recommends::container& recommends)
  {
    this->_xsd_recommends_ = recommends;
  }

  void author::
  recommends (::std::auto_ptr< recommends::type > recommends)
  {
    this->_xsd_recommends_.set (recommends);
  }


  // book
  // 

  const book::isbn::type& book::
  isbn () const
  {
    return this->_xsd_isbn_.get ();
  }

  book::isbn::type& book::
  isbn ()
  {
    return this->_xsd_isbn_.get ();
  }

  void book::
  isbn (const isbn::type& isbn)
  {
    this->_xsd_isbn_.set (isbn);
  }

  void book::
  isbn (::std::auto_ptr< isbn::type > isbn)
  {
    this->_xsd_isbn_.set (isbn);
  }

  const book::title::type& book::
  title () const
  {
    return this->_xsd_title_.get ();
  }

  book::title::type& book::
  title ()
  {
    return this->_xsd_title_.get ();
  }

  void book::
  title (const title::type& title)
  {
    this->_xsd_title_.set (title);
  }

  void book::
  title (::std::auto_ptr< title::type > title)
  {
    this->_xsd_title_.set (title);
  }

  const book::genre::type& book::
  genre () const
  {
    return this->_xsd_genre_.get ();
  }

  book::genre::type& book::
  genre ()
  {
    return this->_xsd_genre_.get ();
  }

  void book::
  genre (const genre::type& genre)
  {
    this->_xsd_genre_.set (genre);
  }

  void book::
  genre (::std::auto_ptr< genre::type > genre)
  {
    this->_xsd_genre_.set (genre);
  }

  const book::author::container& book::
  author () const
  {
    return this->_xsd_author_;
  }

  book::author::container& book::
  author ()
  {
    return this->_xsd_author_;
  }

  void book::
  author (const author::container& author)
  {
    this->_xsd_author_ = author;
  }

  const book::available::type& book::available::
  default_value ()
  {
    return default_value_;
  }

  const book::available::type& book::
  available () const
  {
    return this->_xsd_available_.get ();
  }

  book::available::type& book::
  available ()
  {
    return this->_xsd_available_.get ();
  }

  void book::
  available (const available::type& available)
  {
    this->_xsd_available_.set (available);
  }

  const book::id::type& book::
  id () const
  {
    return this->_xsd_id_.get ();
  }

  book::id::type& book::
  id ()
  {
    return this->_xsd_id_.get ();
  }

  void book::
  id (const id::type& id)
  {
    this->_xsd_id_.set (id);
  }

  void book::
  id (::std::auto_ptr< id::type > id)
  {
    this->_xsd_id_.set (id);
  }


  // catalog
  // 

  const catalog::book::container& catalog::
  book () const
  {
    return this->_xsd_book_;
  }

  catalog::book::container& catalog::
  book ()
  {
    return this->_xsd_book_;
  }

  void catalog::
  book (const book::container& book)
  {
    this->_xsd_book_ = book;
  }
}

#include <xsd/cxx/xml/dom/elements.hxx>
#include <xsd/cxx/xml/dom/parser.hxx>

namespace library
{
  // isbn
  //

  isbn::
  isbn (const _xsd_isbn::base_& _xsd_isbn)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type > (_xsd_isbn)
  {
  }

  isbn::
  isbn (const isbn& _xsd_isbn,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type > (_xsd_isbn, f, c)
  {
  }

  isbn::
  isbn (const ::xercesc::DOMElement& e,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type > (e, f, c)
  {
  }

  isbn::
  isbn (const ::xercesc::DOMAttr& a,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type > (a, f, c)
  {
  }

  isbn::
  isbn (const ::std::basic_string< char >& s,
        const ::xercesc::DOMElement* e,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type > (s, e, f, c)
  {
  }

  isbn* isbn::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new isbn (*this, f, c);
  }

  // title
  //

  title::
  title (const _xsd_title::base_& _xsd_title)
  : ::xml_schema::string (_xsd_title),
  _xsd_lang_ (::xml_schema::flags (), this)
  {
  }

  title::
  title (const title& _xsd_title,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::string (_xsd_title, f, c),
  _xsd_lang_ (_xsd_title._xsd_lang_,
              f | ::xml_schema::flags::not_root,
              this)
  {
  }

  title::
  title (const ::xercesc::DOMElement& e,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::string (e, f, c),
  _xsd_lang_ (f | ::xml_schema::flags::not_root, this)
  {
    parse (e, f);
  }

  void title::
  parse (const ::xercesc::DOMElement& e, ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::parser< char > p (e);

    while (p.more_attributes ())
    {
      const ::xsd::cxx::xml::dom::attribute< char > a (p.next_attribute ());

      if (a.name () == "lang" && a.namespace_ ().empty ())
      {
        ::std::auto_ptr< lang::type > r (
          lang::traits::create (
            a.dom_attribute (),
            f | ::xml_schema::flags::not_root,
            this));

        this->lang (r);
        continue;
      }
    }
  }

  title* title::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new title (*this, f, c);
  }

  // genre
  //

  genre::
  genre (const ::xercesc::DOMElement& e,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::string (e, f, c)
  {
    _xsd_genre_convert ();
  }

  genre::
  genre (const ::xercesc::DOMAttr& a,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::string (a, f, c)
  {
    _xsd_genre_convert ();
  }

  genre::
  genre (const ::std::basic_string< char >& s,
         const ::xercesc::DOMElement* e,
         ::xml_schema::flags f,
         ::xml_schema::type* c)
  : ::xml_schema::string (s, e, f, c)
  {
    _xsd_genre_convert ();
  }

  genre* genre::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new genre (*this, f, c);
  }

  genre::_xsd_genre genre::
  _xsd_genre_convert () const
  {
    ::xsd::cxx::tree::enum_comparator< char > c (_xsd_genre_literals_);
    const _xsd_genre* i (::std::lower_bound (
                           _xsd_genre_indexes_,
                           _xsd_genre_indexes_ + 6,
                           *this,
                           c));

    if (i == _xsd_genre_indexes_ + 6 || _xsd_genre_literals_[*i] != *this)
    {
      throw ::xsd::cxx::tree::unexpected_enumerator < char > (*this);
    }

    return *i;
  }

  const char* const genre::
  _xsd_genre_literals_[6] =
  {
    "romance",
    "fiction",
    "horror",
    "history",
    "philosophy",
    "reference"
  };

  const genre::_xsd_genre genre::
  _xsd_genre_indexes_[6] =
  {
    ::library::genre::fiction,
    ::library::genre::history,
    ::library::genre::horror,
    ::library::genre::philosophy,
    ::library::genre::reference,
    ::library::genre::romance
  };

  // person
  //

  person::
  person (const name::type& _xsd_name,
          const born::type& _xsd_born)
  : ::xml_schema::type (),
  _xsd_name_ (_xsd_name,
              ::xml_schema::flags (),
              this),
  _xsd_born_ (_xsd_born,
              ::xml_schema::flags (),
              this),
  _xsd_died_ (::xml_schema::flags (), this)
  {
  }

  person::
  person (const person& _xsd_person,
          ::xml_schema::flags f,
          ::xml_schema::type* c)
  : ::xml_schema::type (_xsd_person, f, c),
  _xsd_name_ (_xsd_person._xsd_name_,
              f | ::xml_schema::flags::not_root,
              this),
  _xsd_born_ (_xsd_person._xsd_born_,
              f | ::xml_schema::flags::not_root,
              this),
  _xsd_died_ (_xsd_person._xsd_died_,
              f | ::xml_schema::flags::not_root,
              this)
  {
  }

  person::
  person (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f,
          ::xml_schema::type* c)
  : ::xml_schema::type (e, f, c),
  _xsd_name_ (f | ::xml_schema::flags::not_root, this),
  _xsd_born_ (f | ::xml_schema::flags::not_root, this),
  _xsd_died_ (f | ::xml_schema::flags::not_root, this)
  {
    parse (e, f);
  }

  void person::
  parse (const ::xercesc::DOMElement& e, ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::parser< char > p (e);

    while (p.more_elements ())
    {
      const ::xsd::cxx::xml::dom::element< char > e (p.next_element ());

      // name
      //
      {
        if (e.name () == "name" && e.namespace_ ().empty ())
        {
          ::std::auto_ptr< name::type > r (
            name::traits::create (
              e.dom_element (),
              f | ::xml_schema::flags::not_root,
              this));

          if (_xsd_name_.present ())
            continue;
          this->name (r);
          continue;
        }
      }

      // born
      //
      {
        if (e.name () == "born" && e.namespace_ ().empty ())
        {
          ::std::auto_ptr< born::type > r (
            born::traits::create (
              e.dom_element (),
              f | ::xml_schema::flags::not_root,
              this));

          if (_xsd_born_.present ())
            continue;
          this->born (r);
          continue;
        }
      }

      // died
      //
      {
        if (e.name () == "died" && e.namespace_ ().empty ())
        {
          ::std::auto_ptr< died::type > r (
            died::traits::create (
              e.dom_element (),
              f | ::xml_schema::flags::not_root,
              this));

          if (this->died ())
            continue;
          this->died (r);
          continue;
        }
      }
    }

    if (!_xsd_name_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "name",
        "");
    }

    if (!_xsd_born_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "born",
        "");
    }
  }

  person* person::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new person (*this, f, c);
  }

  // author
  //

  author::
  author (const name::type& _xsd_name,
          const born::type& _xsd_born)
  : ::library::person (_xsd_name,
                       _xsd_born),
  _xsd_recommends_ (::xml_schema::flags (), this)
  {
  }

  author::
  author (const author& _xsd_author,
          ::xml_schema::flags f,
          ::xml_schema::type* c)
  : ::library::person (_xsd_author, f, c),
  _xsd_recommends_ (_xsd_author._xsd_recommends_,
                    f | ::xml_schema::flags::not_root,
                    this)
  {
  }

  author::
  author (const ::xercesc::DOMElement& e,
          ::xml_schema::flags f,
          ::xml_schema::type* c)
  : ::library::person (e, f, c),
  _xsd_recommends_ (f | ::xml_schema::flags::not_root, this)
  {
    parse (e, f);
  }

  void author::
  parse (const ::xercesc::DOMElement& e, ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::parser< char > p (e);

    while (p.more_attributes ())
    {
      const ::xsd::cxx::xml::dom::attribute< char > a (p.next_attribute ());

      if (a.name () == "recommends" && a.namespace_ ().empty ())
      {
        ::std::auto_ptr< recommends::type > r (
          recommends::traits::create (
            a.dom_attribute (),
            f | ::xml_schema::flags::not_root,
            this));

        this->recommends (r);
        continue;
      }
    }
  }

  author* author::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new author (*this, f, c);
  }

  // book
  //

  // book::available
  // 

  const book::available::type book::available::default_value_ (
    ::xsd::cxx::tree::traits< ::xml_schema::boolean, char >::create (
      ::std::basic_string< char > ("true"), 0, 0, 0));

  book::
  book (const isbn::type& _xsd_isbn,
        const title::type& _xsd_title,
        const genre::type& _xsd_genre,
        const id::type& _xsd_id)
  : ::xml_schema::type (),
  _xsd_isbn_ (_xsd_isbn,
              ::xml_schema::flags (),
              this),
  _xsd_title_ (_xsd_title,
               ::xml_schema::flags (),
               this),
  _xsd_genre_ (_xsd_genre,
               ::xml_schema::flags (),
               this),
  _xsd_author_ (::xml_schema::flags (), this),
  _xsd_available_ (available::default_value (),
                   ::xml_schema::flags (),
                   this),
  _xsd_id_ (_xsd_id,
            ::xml_schema::flags (),
            this)
  {
  }

  book::
  book (const book& _xsd_book,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::type (_xsd_book, f, c),
  _xsd_isbn_ (_xsd_book._xsd_isbn_,
              f | ::xml_schema::flags::not_root,
              this),
  _xsd_title_ (_xsd_book._xsd_title_,
               f | ::xml_schema::flags::not_root,
               this),
  _xsd_genre_ (_xsd_book._xsd_genre_,
               f | ::xml_schema::flags::not_root,
               this),
  _xsd_author_ (_xsd_book._xsd_author_,
                f | ::xml_schema::flags::not_root,
                this),
  _xsd_available_ (_xsd_book._xsd_available_,
                   f | ::xml_schema::flags::not_root,
                   this),
  _xsd_id_ (_xsd_book._xsd_id_,
            f | ::xml_schema::flags::not_root,
            this)
  {
  }

  book::
  book (const ::xercesc::DOMElement& e,
        ::xml_schema::flags f,
        ::xml_schema::type* c)
  : ::xml_schema::type (e, f, c),
  _xsd_isbn_ (f | ::xml_schema::flags::not_root, this),
  _xsd_title_ (f | ::xml_schema::flags::not_root, this),
  _xsd_genre_ (f | ::xml_schema::flags::not_root, this),
  _xsd_author_ (f | ::xml_schema::flags::not_root, this),
  _xsd_available_ (f | ::xml_schema::flags::not_root, this),
  _xsd_id_ (f | ::xml_schema::flags::not_root, this)
  {
    parse (e, f);
  }

  void book::
  parse (const ::xercesc::DOMElement& e, ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::parser< char > p (e);

    while (p.more_elements ())
    {
      const ::xsd::cxx::xml::dom::element< char > e (p.next_element ());

      // isbn
      //
      {
        if (e.name () == "isbn" && e.namespace_ ().empty ())
        {
          ::std::auto_ptr< isbn::type > r (
            isbn::traits::create (
              e.dom_element (),
              f | ::xml_schema::flags::not_root,
              this));

          if (_xsd_isbn_.present ())
            continue;
          this->isbn (r);
          continue;
        }
      }

      // title
      //
      {
        if (e.name () == "title" && e.namespace_ ().empty ())
        {
          ::std::auto_ptr< title::type > r (
            title::traits::create (
              e.dom_element (),
              f | ::xml_schema::flags::not_root,
              this));

          if (_xsd_title_.present ())
            continue;
          this->title (r);
          continue;
        }
      }

      // genre
      //
      {
        if (e.name () == "genre" && e.namespace_ ().empty ())
        {
          ::std::auto_ptr< genre::type > r (
            genre::traits::create (
              e.dom_element (),
              f | ::xml_schema::flags::not_root,
              this));

          if (_xsd_genre_.present ())
            continue;
          this->genre (r);
          continue;
        }
      }

      // author
      //
      {
        if (e.name () == "author" && e.namespace_ ().empty ())
        {
          ::std::auto_ptr< author::type > r (
            author::traits::create (
              e.dom_element (),
              f | ::xml_schema::flags::not_root,
              this));

          this->author ().push_back (r);
          continue;
        }
      }
    }

    if (!_xsd_isbn_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "isbn",
        "");
    }

    if (!_xsd_title_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "title",
        "");
    }

    if (!_xsd_genre_.present ())
    {
      throw ::xsd::cxx::tree::expected_element< char > (
        "genre",
        "");
    }

    while (p.more_attributes ())
    {
      const ::xsd::cxx::xml::dom::attribute< char > a (p.next_attribute ());

      if (a.name () == "available" && a.namespace_ ().empty ())
      {
        this->available (
          available::traits::create (
            a.dom_attribute (),
            f | ::xml_schema::flags::not_root,
            this));
        continue;
      }

      if (a.name () == "id" && a.namespace_ ().empty ())
      {
        ::std::auto_ptr< id::type > r (
          id::traits::create (
            a.dom_attribute (),
            f | ::xml_schema::flags::not_root,
            this));

        this->id (r);
        continue;
      }
    }

    if (!_xsd_available_.present ())
    {
      this->available (
        available::traits::create (
          ::std::basic_string< char > ("true"),
          &e,
          f | ::xml_schema::flags::not_root,
          this));
    }

    if (!_xsd_id_.present ())
    {
      throw ::xsd::cxx::tree::expected_attribute< char > (
        "id",
        "");
    }
  }

  book* book::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new book (*this, f, c);
  }

  // catalog
  //

  catalog::
  catalog ()
  : ::xml_schema::type (),
  _xsd_book_ (::xml_schema::flags (), this)
  {
  }

  catalog::
  catalog (const catalog& _xsd_catalog,
           ::xml_schema::flags f,
           ::xml_schema::type* c)
  : ::xml_schema::type (_xsd_catalog, f, c),
  _xsd_book_ (_xsd_catalog._xsd_book_,
              f | ::xml_schema::flags::not_root,
              this)
  {
  }

  catalog::
  catalog (const ::xercesc::DOMElement& e,
           ::xml_schema::flags f,
           ::xml_schema::type* c)
  : ::xml_schema::type (e, f, c),
  _xsd_book_ (f | ::xml_schema::flags::not_root, this)
  {
    parse (e, f);
  }

  void catalog::
  parse (const ::xercesc::DOMElement& e, ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::parser< char > p (e);

    while (p.more_elements ())
    {
      const ::xsd::cxx::xml::dom::element< char > e (p.next_element ());

      // book
      //
      {
        if (e.name () == "book" && e.namespace_ ().empty ())
        {
          ::std::auto_ptr< book::type > r (
            book::traits::create (
              e.dom_element (),
              f | ::xml_schema::flags::not_root,
              this));

          this->book ().push_back (r);
          continue;
        }
      }
    }
  }

  catalog* catalog::
  _clone (::xml_schema::flags f,
          ::xml_schema::type* c) const
  {
    return new catalog (*this, f, c);
  }
}

#include <istream>
#include <xercesc/framework/Wrapper4InputSource.hpp>
#include <xsd/cxx/xml/sax/std-input-source.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace library
{
  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::std::basic_string< char >& u,
            ::xml_schema::flags f,
            const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::library::catalog_ (
      static_cast< const ::xercesc::DOMDocument& > (*d), f);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::std::basic_string< char >& u,
            ::xsd::cxx::xml::error_handler< char >& h,
            ::xml_schema::flags f,
            const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

    if (!d)
    {
      throw ::xsd::cxx::tree::parsing< char > ();
    }

    return ::library::catalog_ (
      static_cast< const ::xercesc::DOMDocument& > (*d), f);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::std::basic_string< char >& u,
            ::xercesc::DOMErrorHandler& h,
            ::xml_schema::flags f,
            const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (u, h, p, f));

    if (!d)
    {
      throw ::xsd::cxx::tree::parsing< char > ();
    }

    return ::library::catalog_ (
      static_cast< const ::xercesc::DOMDocument& > (*d), f);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream& is,
            ::xml_schema::flags f,
            const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::library::catalog_ (wrap, f, p);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream& is,
            ::xsd::cxx::xml::error_handler< char >& h,
            ::xml_schema::flags f,
            const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::library::catalog_ (wrap, h, f, p);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream& is,
            ::xercesc::DOMErrorHandler& h,
            ::xml_schema::flags f,
            const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::library::catalog_ (wrap, h, f, p);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream& is,
            const ::std::basic_string< char >& sid,
            ::xml_schema::flags f,
            const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::library::catalog_ (wrap, f, p);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream& is,
            const ::std::basic_string< char >& sid,
            ::xsd::cxx::xml::error_handler< char >& h,
            ::xml_schema::flags f,
            const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0,
      (f & ::xml_schema::flags::keep_dom) == 0);

    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::library::catalog_ (wrap, h, f, p);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (::std::istream& is,
            const ::std::basic_string< char >& sid,
            ::xercesc::DOMErrorHandler& h,
            ::xml_schema::flags f,
            const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::sax::std_input_source isrc (is, sid);
    ::xercesc::Wrapper4InputSource wrap (&isrc, false);
    return ::library::catalog_ (wrap, h, f, p);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::xercesc::DOMInputSource& i,
            ::xml_schema::flags f,
            const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

    h.throw_if_failed< ::xsd::cxx::tree::parsing< char > > ();

    return ::library::catalog_ (
      static_cast< const ::xercesc::DOMDocument& > (*d), f, p);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::xercesc::DOMInputSource& i,
            ::xsd::cxx::xml::error_handler< char >& h,
            ::xml_schema::flags f,
            const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

    if (!d)
    {
      throw ::xsd::cxx::tree::parsing< char > ();
    }

    return ::library::catalog_ (
      static_cast< const ::xercesc::DOMDocument& > (*d), f, p);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::xercesc::DOMInputSource& i,
            ::xercesc::DOMErrorHandler& h,
            ::xml_schema::flags f,
            const ::xsd::cxx::tree::properties< char >& p)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::xsd::cxx::xml::dom::parse< char > (i, h, p, f));

    if (!d)
    {
      throw ::xsd::cxx::tree::parsing< char > ();
    }

    return ::library::catalog_ (
      static_cast< const ::xercesc::DOMDocument& > (*d), f, p);
  }

  ::std::auto_ptr< ::library::catalog >
  catalog_ (const ::xercesc::DOMDocument& d,
            ::xml_schema::flags f,
            const ::xsd::cxx::tree::properties< char >&)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > c (
      (f & ::xml_schema::flags::keep_dom) 
      ? static_cast< ::xercesc::DOMDocument* > (d.cloneNode (true))
      : 0);

    const ::xsd::cxx::xml::dom::element< char > e (
      c.get ()
      ? *c->getDocumentElement ()
      : *d.getDocumentElement ());

    if (e.name () == "catalog" &&
        e.namespace_ () == "http://www.codesynthesis.com/library")
    {
      ::std::auto_ptr< ::library::catalog > r (
        ::xsd::cxx::tree::traits< ::library::catalog, char >::create (
          e.dom_element (), f, 0));
      if (f & ::xml_schema::flags::keep_dom) c.release ();
      return r;
    }

    throw ::xsd::cxx::tree::unexpected_element < char > (
      e.name (),
      e.namespace_ (),
      "catalog",
      "http://www.codesynthesis.com/library");
  }
}

#include <ostream> // std::basic_ostream

namespace library
{
  ::std::basic_ostream< char >&
  operator<< (::std::basic_ostream< char >& o,
              const isbn& i)
  {
    o << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type >& > (i);
    return o;
  }

  ::std::basic_ostream< char >&
  operator<< (::std::basic_ostream< char >& o,
              const title& i)
  {
    o << static_cast< const ::xml_schema::string& > (i);
    if (i.lang ())
    {
      o << ::std::endl << "lang: " << *i.lang ();
    }

    return o;
  }

  ::std::basic_ostream< char >&
  operator<< (::std::basic_ostream< char >& o,
              genre::_xsd_genre i)
  {
    return o << genre::_xsd_genre_literals_[i];
  }

  ::std::basic_ostream< char >&
  operator<< (::std::basic_ostream< char >& o,
              genre i)
  {
    return o << static_cast< const ::xml_schema::string& > (i);
  }

  ::std::basic_ostream< char >&
  operator<< (::std::basic_ostream< char >& o,
              const person& i)
  {
    o << ::std::endl << "name: " << i.name ();
    o << ::std::endl << "born: " << i.born ();
    if (i.died ())
    {
      o << ::std::endl << "died: " << *i.died ();
    }

    return o;
  }

  ::std::basic_ostream< char >&
  operator<< (::std::basic_ostream< char >& o,
              const author& i)
  {
    o << static_cast< const ::library::person& > (i);
    if (i.recommends ())
    {
      o << ::std::endl << "recommends: " << *i.recommends ();
    }

    return o;
  }

  ::std::basic_ostream< char >&
  operator<< (::std::basic_ostream< char >& o,
              const book& i)
  {
    o << ::std::endl << "isbn: " << i.isbn ();
    o << ::std::endl << "title: " << i.title ();
    o << ::std::endl << "genre: " << i.genre ();
    for (book::author::const_iterator
         b (i.author ().begin ()), e (i.author ().end ());
         b != e; ++b)
    {
      o << ::std::endl << "author: " << *b;
    }

    o << ::std::endl << "available: " << i.available ();
    o << ::std::endl << "id: " << i.id ();
    return o;
  }

  ::std::basic_ostream< char >&
  operator<< (::std::basic_ostream< char >& o,
              const catalog& i)
  {
    for (catalog::book::const_iterator
         b (i.book ().begin ()), e (i.book ().end ());
         b != e; ++b)
    {
      o << ::std::endl << "book: " << *b;
    }

    return o;
  }
}

#include <ostream>
#include <xsd/cxx/xml/dom/elements.hxx>
#include <xsd/cxx/xml/dom/serialization.hxx>
#include <xsd/cxx/tree/error-handler.hxx>

namespace library
{
  void
  operator<< (::xercesc::DOMElement& e,
              const isbn& i)
  {
    e << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a,
              const isbn& i)
  {
    a << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xsd::cxx::tree::list_stream< char >& l,
              const isbn& i)
  {
    l << static_cast< const ::xsd::cxx::tree::fundamental_base< ::xml_schema::unsigned_int, char, ::xml_schema::simple_type >& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e,
              const title& i)
  {
    e << static_cast< const ::xml_schema::string& > (i);

    if (i.lang ())
    {
      ::xsd::cxx::xml::dom::attribute< char > a (
        "lang",
        e);

      a.dom_attribute () << *i.lang ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e,
              genre i)
  {
    e << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMAttr& a,
              genre i)
  {
    a << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xsd::cxx::tree::list_stream< char >& l,
              genre i)
  {
    l << static_cast< const ::xml_schema::string& > (i);
  }

  void
  operator<< (::xercesc::DOMElement& e,
              const person& i)
  {
    while (::xercesc::DOMNode* n = e.getFirstChild ())
      e.removeChild (n);

    {
      ::xsd::cxx::xml::dom::element< char > s (
        "name",
        e);
      s.dom_element () << i.name ();
    }

    {
      ::xsd::cxx::xml::dom::element< char > s (
        "born",
        e);
      s.dom_element () << i.born ();
    }

    {
      if (i.died ())
      {
        ::xsd::cxx::xml::dom::element< char > s (
          "died",
          e);
        s.dom_element () << *i.died ();
      }
    }
  }

  void
  operator<< (::xercesc::DOMElement& e,
              const author& i)
  {
    e << static_cast< const ::library::person& > (i);

    if (i.recommends ())
    {
      ::xsd::cxx::xml::dom::attribute< char > a (
        "recommends",
        e);

      a.dom_attribute () << *i.recommends ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e,
              const book& i)
  {
    while (::xercesc::DOMNode* n = e.getFirstChild ())
      e.removeChild (n);

    {
      ::xsd::cxx::xml::dom::element< char > s (
        "isbn",
        e);
      s.dom_element () << i.isbn ();
    }

    {
      ::xsd::cxx::xml::dom::element< char > s (
        "title",
        e);
      s.dom_element () << i.title ();
    }

    {
      ::xsd::cxx::xml::dom::element< char > s (
        "genre",
        e);
      s.dom_element () << i.genre ();
    }

    {
      for (book::author::const_iterator
           b (i.author ().begin ()), n (i.author ().end ());
           b != n; ++b)
      {
        ::xsd::cxx::xml::dom::element< char > s (
          "author",
          e);
        s.dom_element () << *b;
      }
    }

    {
      ::xsd::cxx::xml::dom::attribute< char > a (
        "available",
        e);

      a.dom_attribute () << i.available ();
    }

    {
      ::xsd::cxx::xml::dom::attribute< char > a (
        "id",
        e);

      a.dom_attribute () << i.id ();
    }
  }

  void
  operator<< (::xercesc::DOMElement& e,
              const catalog& i)
  {
    while (::xercesc::DOMNode* n = e.getFirstChild ())
      e.removeChild (n);

    {
      for (catalog::book::const_iterator
           b (i.book ().begin ()), n (i.book ().end ());
           b != n; ++b)
      {
        ::xsd::cxx::xml::dom::element< char > s (
          "book",
          e);
        s.dom_element () << *b;
      }
    }
  }

  void
  catalog_ (::xercesc::DOMDocument& d,
            const ::library::catalog& s,
            ::xml_schema::flags)
  {
    ::xsd::cxx::xml::dom::element< char > e (*d.getDocumentElement ());

    if (e.name () == "catalog" &&
        e.namespace_ () == "http://www.codesynthesis.com/library")
    {
      e.dom_element () << s;
    }
    else
    {
      throw ::xsd::cxx::tree::unexpected_element < char > (
        e.name (),
        e.namespace_ (),
        "catalog",
        "http://www.codesynthesis.com/library");
    }
  }

  ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument >
  catalog_ (const ::library::catalog& s,
            const ::xsd::cxx::xml::dom::namespace_infomap< char >& m,
            ::xml_schema::flags f)
  {
    try
    {
      ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
        ::xsd::cxx::xml::dom::serialize< char > (
          "catalog",
          "http://www.codesynthesis.com/library",
          m,
          f));
      ::library::catalog_ (*d, s, f);
      return d;
    }
    catch (const ::xsd::cxx::xml::dom::mapping< char >& e)
    {
      throw ::xsd::cxx::tree::no_namespace_mapping< char > (e.name ());
    }
    catch (const ::xsd::cxx::xml::dom::xsi_already_in_use&)
    {
      throw ::xsd::cxx::tree::xsi_already_in_use< char > ();
    }
  }

  void
  catalog_ (::xercesc::XMLFormatTarget& t,
            const ::library::catalog& s,
            const ::xsd::cxx::xml::dom::namespace_infomap< char >& m,
            const ::std::basic_string< char >& e,
            ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::library::catalog_ (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  catalog_ (::xercesc::XMLFormatTarget& t,
            const ::library::catalog& s,
            const ::xsd::cxx::xml::dom::namespace_infomap< char >& m,
            ::xsd::cxx::xml::error_handler< char >& h,
            const ::std::basic_string< char >& e,
            ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::library::catalog_ (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  catalog_ (::xercesc::XMLFormatTarget& t,
            const ::library::catalog& s,
            const ::xsd::cxx::xml::dom::namespace_infomap< char >& m,
            ::xercesc::DOMErrorHandler& h,
            const ::std::basic_string< char >& e,
            ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::library::catalog_ (s, m, f));
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  catalog_ (::std::ostream& o,
            const ::library::catalog& s,
            const ::xsd::cxx::xml::dom::namespace_infomap< char >& m,
            const ::std::basic_string< char >& e,
            ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::library::catalog_ (s, m, f));

    ::xsd::cxx::tree::error_handler< char > h;

    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      h.throw_if_failed< ::xsd::cxx::tree::serialization< char > > ();
    }
  }

  void
  catalog_ (::std::ostream& o,
            const ::library::catalog& s,
            const ::xsd::cxx::xml::dom::namespace_infomap< char >& m,
            ::xsd::cxx::xml::error_handler< char >& h,
            const ::std::basic_string< char >& e,
            ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::auto_initializer i (
      (f & ::xml_schema::flags::dont_initialize) == 0);

    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::library::catalog_ (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }

  void
  catalog_ (::std::ostream& o,
            const ::library::catalog& s,
            const ::xsd::cxx::xml::dom::namespace_infomap< char >& m,
            ::xercesc::DOMErrorHandler& h,
            const ::std::basic_string< char >& e,
            ::xml_schema::flags f)
  {
    ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument > d (
      ::library::catalog_ (s, m, f));
    ::xsd::cxx::xml::dom::ostream_format_target t (o);
    if (!::xsd::cxx::xml::dom::serialize (t, *d, e, h, f))
    {
      throw ::xsd::cxx::tree::serialization< char > ();
    }
  }
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

