// file      : examples/cxx/tree/polymorphism/driver.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : not copyrighted - public domain

#include <memory>   // std::auto_ptr
#include <iostream>

#include "schema.hxx"

using std::cerr;
using std::endl;
using std::auto_ptr;

int
main (int argc, char* argv[])
{
  if (argc != 2)
  {
    cerr << "usage: " << argv[0] << " instance.xml" << endl;
    return 1;
  }

  try
  {
    auto_ptr<instance_type> inst (instance (argv[1]));

    instance_type copy (*inst); // Dynamic types are preserved in copies.

    // Print what we've got.
    //
    for (instance_type::person::const_iterator i (copy.person ().begin ());
         i != copy.person ().end ();
         ++i)
    {
      cerr << i->name ();

      if (superman_type const* s = dynamic_cast<superman_type const*> (&*i))
      {
        if (s->can_fly ())
          cerr << ", flying superman";
        else
          cerr << ", superman";
      }

      cerr << endl;
    }

    // Serialize back to XML.
    //
    xml_schema::namespace_infomap map;
    map[""].schema = "schema.xsd";

    instance (std::cout, copy, map);
  }
  catch (xml_schema::exception const& e)
  {
    cerr << e << endl;
    return 1;
  }
}
