// file      : examples/cxx/parser/mixed/driver.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : not copyrighted - public domain

#include <string>
#include <vector>
#include <iostream>

#include "text.hxx"

using std::cout;
using std::cerr;
using std::endl;
using std::string;


struct anchor
{
  anchor (string const& text, string const& uri)
      : uri_ (uri), text_ (text)
  {
  }

  string const&
  text () const
  {
    return text_;
  }

  string const&
  uri () const
  {
    return uri_;
  }

private:
  string uri_;
  string text_;
};


struct anchor_parser: anchor_type<anchor, string>
{
  virtual void
  href (string const& uri)
  {
    uri_ = uri;
  }

  virtual void
  _characters (string const& s)
  {
    text_ = s;
  }

  virtual anchor
  post ()
  {
    return anchor (text_, uri_);
  }

private:
  string uri_;
  string text_;
};


struct text_parser: text_type<void, anchor>
{
  virtual void
  a (anchor const& a)
  {
    cout << a.text () << "[" << anchors_.size () << "]";
    anchors_.push_back (a);
  }

  virtual void
  _unexpected_characters (string const& s)
  {
    cout << s;
  }

  virtual void
  post ()
  {
    for (anchors::const_iterator i (anchors_.begin ());
         i != anchors_.end ();
         ++i)
    {
      cout << "[" << i - anchors_.begin () << "] " << i->uri () << endl;
    }
  }

private:
  typedef std::vector<anchor> anchors;
  anchors anchors_;
};


int
main (int argc, char* argv[])
{
  if (argc != 2)
  {
    cerr << "usage: " << argv[0] << " text.xml" << endl;
    return 1;
  }

  try
  {
    // Construct the parser.
    //
    xml_schema::string string_p;
    anchor_parser anchor_p;
    text_parser text_p;

    anchor_p.href_parser (string_p);
    text_p.a_parser (anchor_p);

    // Parse the XML instance document.
    //
    text_p._parse (argv[1],
                   "",      // root element namespace
                   "text"); // root element name
  }
  catch (xml_schema::exception const& e)
  {
    cerr << e << endl;
    return 1;
  }
  catch (std::ios_base::failure const&)
  {
    cerr << "io failure" << endl;
    return 1;
  }
}
