// file      : xsd/cxx/parser/elements.txx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2006 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

namespace xsd
{
  namespace cxx
  {
    namespace parser
    {
      // traverser_impl
      //

      template <typename C>
      bool traverser_impl<C>::
      _start_element_ (std::basic_string<C> const& ns,
                       std::basic_string<C> const& n,
                       traverser_base<C>* cur)
      {
        bool r (false);

        if (count_ != 0)
        {
          cur_->_start_element (ns, n);
        }
        else
        {
          cur_ = cur;
          r = true;
        }

        ++count_;

        return r;
      }

      template <typename C>
      bool traverser_impl<C>::
      _end_element_ (std::basic_string<C> const& ns,
                     std::basic_string<C> const& n)
      {
        bool r (false);

        --count_;

        if (count_ != 0)
        {
          cur_->_end_element (ns, n);
        }
        else
        {
          cur_ = 0;
          r = true;
        }

        return r;
      }
    }
  }
}
