# file      : examples/build/xsd/parser-rules.make
# author    : Boris Kolpackov <boris@codesynthesis.com>
# copyright : Copyright (c) 2006 Code Synthesis Tools CC
# license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

include $(root)/build/xsd/common.make


XML_PARSER := xerces

ifeq ($(XML_PARSER),xerces)
override LIBS += -lxerces-c
else
override LIBS += -lexpat
endif

override XSDFLAGS += --xml-parser $(XML_PARSER)


# Rules.
#
ifeq ($(xsd_cxx_suffix),)

.PRECIOUS: %.hxx %.ixx %.txx

%.hxx %.ixx %.txx: %.xsd
	$(XSD) cxx-parser $(XSDFLAGS) $<

else

.PRECIOUS: %$(xsd_cxx_suffix).hxx \
           %$(xsd_cxx_suffix).ixx \
           %$(xsd_cxx_suffix).txx

xsd_suffixes := --hxx-suffix $(xsd_cxx_suffix).hxx \
--ixx-suffix $(xsd_cxx_suffix).ixx --txx-suffix $(xsd_cxx_suffix).txx

%$(xsd_cxx_suffix).hxx \
%$(xsd_cxx_suffix).ixx \
%$(xsd_cxx_suffix).txx: %.xsd
	$(XSD) cxx-parser $(XSDFLAGS) $(xsd_suffixes) $<

endif
