// file      : xsd/cxx/tree/type-factory-map.ixx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2006 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#if defined(XSD_CXX_TREE_USE_CHAR) || !defined(XSD_CXX_TREE_USE_WCHAR)

#ifndef XSD_CXX_TREE_TYPE_FACTORY_MAP_IXX_CHAR
#define XSD_CXX_TREE_TYPE_FACTORY_MAP_IXX_CHAR

namespace xsd
{
  namespace cxx
  {
    namespace tree
    {
      template <>
      inline type_factory_map<char>::
      type_factory_map ()
      {
        // Register factories for built-in non-fundamental types.
        //

        std::basic_string<char> xsd ("http://www.w3.org/2001/XMLSchema");


        // anyType and anySimpleType.
        //
        register_type (
          "anyType " + xsd,
          &factory_impl<type>);

        register_type (
          "anySimpleType " + xsd,
          &factory_impl<simple_type>);


        // Strings
        //
        register_type (
          "string " + xsd,
          &factory_impl<string<char> >);

        register_type (
          "normalizedString " + xsd,
          &factory_impl<normalized_string<char> >);

        register_type (
          "token " + xsd,
          &factory_impl<token<char> >);

        register_type (
          "Name " + xsd,
          &factory_impl<name<char> >);

        register_type (
          "NMTOKEN " + xsd,
          &factory_impl<nmtoken<char> >);

        register_type (
          "NMTOKENS " + xsd,
          &factory_impl<nmtokens<char> >);

        register_type (
          "NCName " + xsd,
          &factory_impl<ncname<char> >);

        register_type (
          "language " + xsd,
          &factory_impl<language<char> >);


        // Qualified name.
        //
        register_type (
          "QName " + xsd,
          &factory_impl<qname<char> >);


        // ID/IDREF.
        //
        register_type (
          "ID " + xsd,
          &factory_impl<id<char> >);

        register_type (
          "IDREF " + xsd,
          &factory_impl<idref<type, char> >);

        register_type (
          "IDREFS " + xsd,
          &factory_impl<idrefs<type, char> >);


        // URI.
        //
        register_type (
          "anyURI " + xsd,
          &factory_impl<uri<char> >);


        // Binary.
        //
        register_type (
          "base64Binary " + xsd,
          &factory_impl<base64_binary<char> >);

        register_type (
          "hexBinary " + xsd,
          &factory_impl<hex_binary<char> >);


        // Date/time.
        //
        register_type (
          "date " + xsd,
          &factory_impl<date<char> >);

        register_type (
          "dateTime " + xsd,
          &factory_impl<date_time<char> >);

        register_type (
          "duration " + xsd,
          &factory_impl<duration<char> >);

        register_type (
          "gDay " + xsd,
          &factory_impl<day<char> >);

        register_type (
          "gMonth " + xsd,
          &factory_impl<month<char> >);

        register_type (
          "gMonthDay " + xsd,
          &factory_impl<month_day<char> >);

        register_type (
          "gYear " + xsd,
          &factory_impl<year<char> >);

        register_type (
          "gYearMonth " + xsd,
          &factory_impl<year_month<char> >);

        register_type (
          "time " + xsd,
          &factory_impl<time<char> >);


        // Entity.
        //
        register_type (
          "ENTITY " + xsd,
          &factory_impl<entity<char> >);

        register_type (
          "ENTITIES " + xsd,
          &factory_impl<entities<char> >);
      }
    }
  }
}

#endif // XSD_CXX_TREE_TYPE_FACTORY_MAP_IXX_CHAR
#endif // XSD_CXX_TREE_USE_CHAR


#if defined(XSD_CXX_TREE_USE_WCHAR) || !defined(XSD_CXX_TREE_USE_CHAR)

#ifndef XSD_CXX_TREE_TYPE_FACTORY_MAP_IXX_WCHAR
#define XSD_CXX_TREE_TYPE_FACTORY_MAP_IXX_WCHAR

namespace xsd
{
  namespace cxx
  {
    namespace tree
    {
      template <>
      inline type_factory_map<wchar_t>::
      type_factory_map ()
      {
        // Register factories for built-in non-fundamental types.
        //

        std::basic_string<wchar_t> xsd (L"http://www.w3.org/2001/XMLSchema");


        // anyType and anySimpleType.
        //
        register_type (
          L"anyType " + xsd,
          &factory_impl<type>);

        register_type (
          L"anySimpleType " + xsd,
          &factory_impl<simple_type>);


        // Strings
        //
        register_type (
          L"string " + xsd,
          &factory_impl<string<wchar_t> >);

        register_type (
          L"normalizedString " + xsd,
          &factory_impl<normalized_string<wchar_t> >);

        register_type (
          L"token " + xsd,
          &factory_impl<token<wchar_t> >);

        register_type (
          L"Name " + xsd,
          &factory_impl<name<wchar_t> >);

        register_type (
          L"NMTOKEN " + xsd,
          &factory_impl<nmtoken<wchar_t> >);

        register_type (
          L"NMTOKENS " + xsd,
          &factory_impl<nmtokens<wchar_t> >);

        register_type (
          L"NCName " + xsd,
          &factory_impl<ncname<wchar_t> >);

        register_type (
          L"language " + xsd,
          &factory_impl<language<wchar_t> >);


        // Qualified name.
        //
        register_type (
          L"QName " + xsd,
          &factory_impl<qname<wchar_t> >);


        // ID/IDREF.
        //
        register_type (
          L"ID " + xsd,
          &factory_impl<id<wchar_t> >);

        register_type (
          L"IDREF " + xsd,
          &factory_impl<idref<type, wchar_t> >);

        register_type (
          L"IDREFS " + xsd,
          &factory_impl<idrefs<type, wchar_t> >);


        // URI.
        //
        register_type (
          L"anyURI " + xsd,
          &factory_impl<uri<wchar_t> >);


        // Binary.
        //
        register_type (
          L"base64Binary " + xsd,
          &factory_impl<base64_binary<wchar_t> >);

        register_type (
          L"hexBinary " + xsd,
          &factory_impl<hex_binary<wchar_t> >);


        // Date/time.
        //
        register_type (
          L"date " + xsd,
          &factory_impl<date<wchar_t> >);

        register_type (
          L"dateTime " + xsd,
          &factory_impl<date_time<wchar_t> >);

        register_type (
          L"duration " + xsd,
          &factory_impl<duration<wchar_t> >);

        register_type (
          L"gDay " + xsd,
          &factory_impl<day<wchar_t> >);

        register_type (
          L"gMonth " + xsd,
          &factory_impl<month<wchar_t> >);

        register_type (
          L"gMonthDay " + xsd,
          &factory_impl<month_day<wchar_t> >);

        register_type (
          L"gYear " + xsd,
          &factory_impl<year<wchar_t> >);

        register_type (
          L"gYearMonth " + xsd,
          &factory_impl<year_month<wchar_t> >);

        register_type (
          L"time " + xsd,
          &factory_impl<time<wchar_t> >);


        // Entity.
        //
        register_type (
          L"ENTITY " + xsd,
          &factory_impl<entity<wchar_t> >);

        register_type (
          L"ENTITIES " + xsd,
          &factory_impl<entities<wchar_t> >);
      }
    }
  }
}

#endif // XSD_CXX_TREE_TYPE_FACTORY_MAP_IXX_WCHAR
#endif // XSD_CXX_TREE_USE_WCHAR
