// file      : xsd/cxx/tree/serialization.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2006 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef XSD_CXX_TREE_SERIALIZATION_HXX
#define XSD_CXX_TREE_SERIALIZATION_HXX

#include <sstream>

#include <xsd/cxx/xml/dom/elements.hxx>
#include <xsd/cxx/xml/dom/serialization.hxx>

#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/types.hxx>

namespace xsd
{
  namespace cxx
  {
    namespace tree
    {
      // Insertion operators for type.
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>&, type const&)
      {
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>&, type const&)
      {
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>&, type const&)
      {
      }

      // Insertion operators for simple_type.
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>&, simple_type const&)
      {
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>&, simple_type const&)
      {
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>&, simple_type const&)
      {
      }

      // Insertion operators for sequence.
      //
      template <typename C, typename X, bool fund>
      void
      operator<< (xml::dom::element<C>& e, sequence<X, fund> const& v)
      {
        std::basic_ostringstream<C> os;
        xml::dom::list_stream<C> ls (os, e);

        ls << v;

        e.value (os.str ());
      }

      template <typename C, typename X, bool fund>
      void
      operator<< (xml::dom::attribute<C>& a, sequence<X, fund> const& v)
      {
        std::basic_ostringstream<C> os;
        xml::dom::list_stream<C> ls (os, a.element ());

        ls << v;

        a.value (os.str ());
      }

      template <typename C, typename X, bool fund>
      void
      operator<< (xml::dom::list_stream<C>& ls, sequence<X, fund> const& v)
      {
        for (typename sequence<X, fund>::const_iterator
               b (v.begin ()), e (v.end ()), i (b); i != e; ++i)
        {
          if (i != b)
            ls.os_ << C (' ');

          ls << *i;
        }
      }


      // Insertion operators for fundamental_base.
      //
      template <typename X, typename C>
      void
      operator<< (xml::dom::element<C>& e, fundamental_base<X> const& x)
      {
        X const& r (x);
        e << r;
      }

      template <typename X, typename C>
      void
      operator<< (xml::dom::attribute<C>& a, fundamental_base<X> const& x)
      {
        X const& r (x);
        a << r;
      }

      template <typename X, typename C>
      void
      operator<< (xml::dom::list_stream<C>& ls, fundamental_base<X> const& x)
      {
        X const& r (x);
        ls << r;
      }


      // Insertion operators for built-in types.
      //


      namespace bits
      {
        template <typename X, typename C>
        void
        insert (xml::dom::element<C>& e, X const& x)
        {
          std::basic_ostringstream<C> os;
          os << x;
          e.value (os.str ());
        }

        template <typename X, typename C>
        void
        insert (xml::dom::attribute<C>& a, X const& x)
        {
          std::basic_ostringstream<C> os;
          os << x;
          a.value (os.str ());
        }
      }


      // string
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, string<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, string<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, string<C> const& x)
      {
        ls.os_ << x;
      }


      // normalized_string
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e,
                  normalized_string<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a,
                  normalized_string<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls,
                  normalized_string<C> const& x)
      {
        ls.os_ << x;
      }


      // token
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, token<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, token<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, token<C> const& x)
      {
        ls.os_ << x;
      }


      // nmtoken
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, nmtoken<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, nmtoken<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, nmtoken<C> const& x)
      {
        ls.os_ << x;
      }


      // nmtokens
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, nmtokens<C> const& v)
      {
        sequence<nmtoken<C> > const& r (v);
        e << r;
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, nmtokens<C> const& v)
      {
        sequence<nmtoken<C> > const& r (v);
        a << r;
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, nmtokens<C> const& v)
      {
        sequence<nmtoken<C> > const& r (v);
        ls << r;
      }


      // name
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, name<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, name<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, name<C> const& x)
      {
        ls.os_ << x;
      }


      // ncname
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, ncname<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, ncname<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, ncname<C> const& x)
      {
        ls.os_ << x;
      }


      // language
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, language<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, language<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, language<C> const& x)
      {
        ls.os_ << x;
      }


      // id
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, id<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, id<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, id<C> const& x)
      {
        ls.os_ << x;
      }


      // idref
      //
      template <typename X, typename C>
      inline void
      operator<< (xml::dom::element<C>& e, idref<X, C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename X, typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, idref<X, C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename X, typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, idref<X, C> const& x)
      {
        ls.os_ << x;
      }


      // idrefs
      //
      template <typename X, typename C>
      inline void
      operator<< (xml::dom::element<C>& e, idrefs<X, C> const& v)
      {
        sequence<idref<X, C> > const& r (v);
        e << r;
      }

      template <typename X, typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, idrefs<X, C> const& v)
      {
        sequence<idref<X, C> > const& r (v);
        a << r;
      }

      template <typename X, typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls,
                  idrefs<X, C> const& v)
      {
        sequence<idref<X, C> > const& r (v);
        ls << r;
      }


      // uri
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, uri<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, uri<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, uri<C> const& x)
      {
        ls.os_ << x;
      }


      // qname
      //
      template <typename C>
      void
      operator<< (xml::dom::element<C>& e, qname<C> const& x)
      {
        std::basic_ostringstream<C> os;
        std::basic_string<C> p (xml::dom::prefix<C> (x.namespace_ (), e));

        if (!p.empty ())
          os << p << C (':');

        os << x.name ();

        e.value (os.str ());
      }

      template <typename C>
      void
      operator<< (xml::dom::attribute<C>& a, qname<C> const& x)
      {
        std::basic_ostringstream<C> os;
        std::basic_string<C> p (
          xml::dom::prefix<C> (x.namespace_ (), a.element ()));

        if (!p.empty ())
          os << p << C (':');

        os << x.name ();

        a.value (os.str ());
      }

      template <typename X, typename C>
      void
      operator<< (xml::dom::list_stream<C>& ls, qname<C> const& x)
      {
        std::basic_string<C> p (
          xml::dom::prefix<C> (x.namespace_ (), ls.parent));

        if (!p.empty ())
          ls.os_ << p << C (':');

        ls.os_ << x.name ();
      }


      // base64_binary
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e,
                  base64_binary<C> const& x)
      {
        e.value (x.encode ());
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a,
                  base64_binary<C> const& x)
      {
        a.value (x.encode ());
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls,
                  base64_binary<C> const& x)
      {
        ls.os_ << x.encode ();
      }


      // hex_binary
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, hex_binary<C> const& x)
      {
        e.value (x.encode ());
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, hex_binary<C> const& x)
      {
        a.value (x.encode ());
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls,
                  hex_binary<C> const& x)
      {
        ls.os_ << x.encode ();
      }


      // date
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, date<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, date<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, date<C> const& x)
      {
        ls.os_ << x;
      }


      // date_time
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, date_time<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, date_time<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, date_time<C> const& x)
      {
        ls.os_ << x;
      }


      // duration
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, duration<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, duration<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, duration<C> const& x)
      {
        ls.os_ << x;
      }


      // day
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, day<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, day<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, day<C> const& x)
      {
        ls.os_ << x;
      }


      // month
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, month<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, month<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, month<C> const& x)
      {
        ls.os_ << x;
      }


      // month_day
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, month_day<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, month_day<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, month_day<C> const& x)
      {
        ls.os_ << x;
      }


      // year
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, year<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, year<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, year<C> const& x)
      {
        ls.os_ << x;
      }


      // year_month
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, year_month<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, year_month<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls,
                  year_month<C> const& x)
      {
        ls.os_ << x;
      }


      // time
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, time<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, time<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, time<C> const& x)
      {
        ls.os_ << x;
      }


      // entity
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, entity<C> const& x)
      {
        bits::insert (e, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, entity<C> const& x)
      {
        bits::insert (a, x);
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, entity<C> const& x)
      {
        ls.os_ << x;
      }


      // entities
      //
      template <typename C>
      inline void
      operator<< (xml::dom::element<C>& e, entities<C> const& v)
      {
        sequence<entity<C> > const& r (v);
        e << r;
      }

      template <typename C>
      inline void
      operator<< (xml::dom::attribute<C>& a, entities<C> const& v)
      {
        sequence<entity<C> > const& r (v);
        a << r;
      }

      template <typename C>
      inline void
      operator<< (xml::dom::list_stream<C>& ls, entities<C> const& v)
      {
        sequence<entity<C> > const& r (v);
        ls << r;
      }
    }
  }
}

#endif  // XSD_CXX_TREE_SERIALIZATION_HXX
