// file      : xsd/cxx/xml/bits/literals.ixx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2006 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef XSD_CXX_XML_BITS_LITERALS_IXX
#define XSD_CXX_XML_BITS_LITERALS_IXX

#endif // XSD_CXX_XML_BITS_LITERALS_IXX


#if defined(XSD_USE_CHAR) || !defined(XSD_USE_WCHAR)

#ifndef XSD_CXX_XML_BITS_LITERALS_IXX_CHAR
#define XSD_CXX_XML_BITS_LITERALS_IXX_CHAR

namespace xsd
{
  namespace cxx
  {
    namespace xml
    {
      namespace bits
      {
        template <>
        inline char const*
        load_store<char> ()
        {
          return "LS";
        }

        template <>
        inline char const*
        xml_prefix<char> ()
        {
          return "xml";
        }

        template <>
        inline char const*
        xml_namespace<char> ()
        {
          return "http://www.w3.org/XML/1998/namespace";
        }

        template <>
        inline char const*
        xmlns_prefix<char> ()
        {
          return "xmlns";
        }

        template <>
        inline char const*
        xmlns_namespace<char> ()
        {
          return "http://www.w3.org/2000/xmlns/";
        }

        template <>
        inline char const*
        xsi_prefix<char> ()
        {
          return "xsi";
        }

        template <>
        inline char const*
        xsi_namespace<char> ()
        {
          return "http://www.w3.org/2001/XMLSchema-instance";
        }

        template <>
        inline char const*
        type<char> ()
        {
          return "type";
        }

        template <>
        inline char const*
        schema_location<char> ()
        {
          return "schemaLocation";
        }

        template <>
        inline char const*
        no_namespace_schema_location<char> ()
        {
          return "noNamespaceSchemaLocation";
        }
      }
    }
  }
}

#endif // XSD_CXX_XML_BITS_LITERALS_IXX_CHAR
#endif // XSD_USE_CHAR


#if defined(XSD_USE_WCHAR) || !defined(XSD_USE_CHAR)

#ifndef XSD_CXX_XML_BITS_LITERALS_IXX_WCHAR
#define XSD_CXX_XML_BITS_LITERALS_IXX_WCHAR

namespace xsd
{
  namespace cxx
  {
    namespace xml
    {
      namespace bits
      {
        template <>
        inline wchar_t const*
        load_store<wchar_t> ()
        {
          return L"LS";
        }

        template <>
        inline wchar_t const*
        xml_prefix<wchar_t> ()
        {
          return L"xml";
        }

        template <>
        inline wchar_t const*
        xml_namespace<wchar_t> ()
        {
          return L"http://www.w3.org/XML/1998/namespace";
        }

        template <>
        inline wchar_t const*
        xmlns_prefix<wchar_t> ()
        {
          return L"xmlns";
        }

        template <>
        inline wchar_t const*
        xmlns_namespace<wchar_t> ()
        {
          return L"http://www.w3.org/2000/xmlns/";
        }

        template <>
        inline wchar_t const*
        xsi_prefix<wchar_t> ()
        {
          return L"xsi";
        }

        template <>
        inline wchar_t const*
        xsi_namespace<wchar_t> ()
        {
          return L"http://www.w3.org/2001/XMLSchema-instance";
        }

        template <>
        inline wchar_t const*
        type<wchar_t> ()
        {
          return L"type";
        }

        template <>
        inline wchar_t const*
        schema_location<wchar_t> ()
        {
          return L"schemaLocation";
        }

        template <>
        inline wchar_t const*
        no_namespace_schema_location<wchar_t> ()
        {
          return L"noNamespaceSchemaLocation";
        }
      }
    }
  }
}

#endif // XSD_CXX_XML_BITS_LITERALS_IXX_WCHAR
#endif // XSD_USE_WCHAR
