// file      : xsd/cxx-cli/parser/types.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2006 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef XSD_CXX_CLI_PARSER_TYPES_HXX
#define XSD_CXX_CLI_PARSER_TYPES_HXX

#using <System.dll>

//#include <sstream>

#include <xsd/cxx-cli/parser/elements.hxx>

namespace xsd
{
  namespace cxx_cli
  {
    namespace parser
    {
      /*
      // 8-bit
      //
      //

      template <typename C>
      struct byte: traverser<signed char, C>
      {
        typedef signed char type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          short t;
          is >> t;

          v_ = static_cast<type> (t);
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };


      template <typename C>
      struct unsigned_byte: traverser<unsigned char, C>
      {
        typedef unsigned char type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          unsigned short t;
          is >> t;

          v_ = static_cast<type> (t);
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };



      // 16-bit
      //
      //

      template <typename C>
      struct short_: traverser<short, C>
      {
        typedef short type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };


      template <typename C>
      struct unsigned_short: traverser<unsigned short, C>
      {
        typedef unsigned short type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };



      // 32-bit
      //
      //

      template <typename C>
      struct int_: traverser<int, C>
      {
        typedef int type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };


      template <typename C>
      struct unsigned_int: traverser<unsigned int, C>
      {
        typedef unsigned int type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };



      // 64-bit
      //
      //

      template <typename C>
      struct long_: traverser<long long, C>
      {
        typedef long long type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };


      template <typename C>
      struct unsigned_long: traverser<unsigned long long, C>
      {
        typedef unsigned long long type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };



      // Boolean.
      //
      //

      template <typename C>
      struct boolean: traverser<bool, C>
      {
        typedef bool type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };


      // Floats.
      //
      //

      template <typename C>
      struct float_: traverser<float, C>
      {
        typedef float type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };


      template <typename C>
      struct double_: traverser<double, C>
      {
        typedef double type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };

      template <typename C>
      struct decimal: traverser<long double, C>
      {
        typedef long double type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };
      */


      // String.
      //
      //

      public ref class String: Traverser<System::String>
      {
      public:
        typedef System::String Type;

        virtual void
        _characters (System::String^ s)
        {
          s_ = s;
        }

        virtual Type^
        post ()
        {
          return s_;
        }

      private:
        Type^ s_;
      };
    }
  }
}

#endif  // XSD_CXX_CLI_PARSER_TYPES_HXX

#include <xsd/cxx-cli/parser/types.ixx>
