// file      : xsd/cxx-cli/parser/exceptions.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2006 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef XSD_CXX_CLI_PARSER_EXCEPTIONS_HXX
#define XSD_CXX_CLI_PARSER_EXCEPTIONS_HXX

#include <string>
#include <xsd/cxx/exceptions.hxx> // xsd::cxx::exception

namespace xsd
{
  namespace cxx_cli
  {
    namespace parser
    {
      //
      //
      struct exception: virtual xsd::cxx::exception
      {
      };


      //
      //
      struct invalid_instance: virtual exception
      {
        virtual char const*
        what () const throw ()
        {
          return "instance document is not valid";
        }
      };


      //
      //
      template <typename C>
      struct unexpected_element: virtual exception
      {
        virtual
        ~unexpected_element () throw ()
        {
        }

        unexpected_element (std::basic_string<C> const& encountered,
                            std::basic_string<C> const& expected)
            : encountered_ (encountered),
              expected_ (expected)
        {
        }

        virtual char const*
        what () const throw ()
        {
          return "unexpected element encountered";
        }

        // Encountered element.
        //
        std::basic_string<C> const&
        encountered () const
        {
          return encountered_;
        }

        // Space-separated list of names of expected elements.
        //
        std::basic_string<C> const&
        expected () const
        {
          return expected_;
        }

      private:
        std::basic_string<C> encountered_;
        std::basic_string<C> expected_;
      };
    }
  }
}

#endif  // XSD_CXX_CLI_PARSER_EXCEPTIONS_HXX
