// file      : xsd/cxx-cli/parser/elements.txx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2006 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <memory> //@@ tmp

#include <xercesc/sax2/Attributes.hpp>
#include <xercesc/sax2/XMLReaderFactory.hpp>

#include <xsd/cxx/xml/string.hxx>
#include <xsd/cxx/xml/sax/error-handler.hxx>
#include <xsd/cxx/xml/sax/std-input-source.hxx>

namespace xsd
{
  namespace cxx_cli
  {
    namespace parser
    {
      // sax_event_router
      //
      inline
      void sax_event_router::
      startElement(XMLCh const* const uri,
                   XMLCh const* const lname,
                   XMLCh const* const /*qname*/,
                   xercesc::Attributes const& attributes)
      {
        if (!buf_.empty ())
        {
          System::String cli_buf (gcnew System::String (buf_.c_str ()));
          t_._characters (cli_buf);
          buf_.clear ();
        }

        string ns (xml::transcode<wchar_t> (uri));
        string name (xml::transcode<wchar_t> (lname));

        System::String cli_ns (gcnew System::String (ns.c_str ()));
        System::String cli_name (gcnew System::String (name.c_str ()));

        t_._start_element (cli_ns, cli_name);

        for (unsigned long i (0); i < attributes.getLength(); ++i)
        {
          string ns (xml::transcode<wchar_t> (attributes.getURI (i)));
          string name (xml::transcode<wchar_t> (attributes.getLocalName (i)));
          string value (xml::transcode<wchar_t> (attributes.getValue (i)));

          System::String cli_ns (gcnew System::String (ns.c_str ()));
          System::String cli_name (gcnew System::String (name.c_str ()));
          System::String cli_value (gcnew System::String (value.c_str ()));

          t_._attribute (cli_ns, cli_name, cli_value);
        }
      }

      inline
      void sax_event_router::
      endElement(XMLCh const* const uri,
                 XMLCh const* const lname,
                 XMLCh const* const /*qname*/)
      {
        if (!buf_.empty ())
        {
          System::String cli_buf (gcnew System::String (buf_.c_str ()));
          t_._characters (cli_buf);
          buf_.clear ();
        }

        string ns (xml::transcode<wchar_t> (uri));
        string name (xml::transcode<wchar_t> (lname));

        System::String cli_ns (gcnew System::String (ns.c_str ()));
        System::String cli_name (gcnew System::String (name.c_str ()));

        t_._end_element (cli_ns, cli_name);
      }

      inline
      void sax_event_router::
      characters (XMLCh const* const s, unsigned int const length)
      {
        if (length == 0)
          return;

        buf_ += xml::transcode<wchar_t> (s, length);
      }


      // TraverserBase
      //

      inline
      bool TraverserBase::
      _start_element_ (System::String^ ns,
                       System::String^ n,
                       ITraverser^ cur)
      {
        bool r (false);

        if (count_ != 0)
        {
          cur_->_start_element (ns, n);
        }
        else
        {
          cur_ = cur;
          r = true;
        }

        ++count_;

        return r;
      }

      inline
      bool TraverserBase::
      _end_element_ (System::String^ ns, System::String^ n)
      {
        bool r (false);

        --count_;

        if (count_ != 0)
        {
          cur_->_end_element (ns, n);
        }
        else
        {
          cur_ = nullptr;
          r = true;
        }

        return r;
      }

      // Traverser
      //

      generic <typename X>
      X^ Traverser<X>::
      _parse (System::String const^ cli_uri,
              System::String const^ root_element_name,
              System::String const^ root_element_namespace)
      {
        std::basic_string<wchar_t> uri (
          pin_ptr<wchar_t const> (PtrToStringChars (cli_uri)));

        /*
        std::basic_string<wchar_t> root_element_name (
          pin_ptr<wchar_t const> (PtrToStringChars (cli_root_element_name)));

        std::basic_string<wchar_t> root_element_namespace (
          pin_ptr<wchar_t const> (PtrToStringChars (cli_root_element_namespace)));
        */

        xml::auto_initializer init;

        // Create SAX
        //
        std::auto_ptr<xercesc::SAX2XMLReader> sax;
        {
          using namespace xercesc;

          sax = std::auto_ptr<SAX2XMLReader> sax (
            XMLReaderFactory::createXMLReader());

          sax->setFeature(XMLUni::fgSAX2CoreNameSpaces, true);
          sax->setFeature(XMLUni::fgSAX2CoreNameSpacePrefixes, true);
          sax->setFeature (XMLUni::fgXercesValidationErrorAsFatal, true);

          sax->setFeature(XMLUni::fgSAX2CoreValidation, true);
          sax->setFeature(XMLUni::fgXercesSchema, true);
          sax->setFeature(XMLUni::fgXercesSchemaFullChecking, true);
        }

        // Parse
        //
        using namespace xercesc;

        document doc (*this, root_element_name, root_element_namespace);
        sax_event_router router (doc);

        ErrorHandler* old_eh (sax.getErrorHandler ());
        xml::sax::error_handler<wchar_t> eh (old_eh);

        try
        {
          sax.setErrorHandler (&eh);

          sax.setContentHandler (&router);
          sax.parse (xml::string (uri).c_str ());

          sax.setErrorHandler (old_eh);
        }
        catch (...)
        {
          sax.setErrorHandler (old_eh);
          throw;
        }

        if (eh.failed ())
          throw invalid_instance ();

        return post ();
      }
    }
  }
}
