// file      : examples/cxx/tree/hello/driver.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : not copyrighted - public domain

#include <memory>   // std::auto_ptr
#include <iostream>

#include "hello.hxx"

using std::cerr;
using std::endl;
using std::auto_ptr;

int
main (int argc, char* argv[])
{
  if (argc != 2)
  {
    cerr << "usage: " << argv[0] << " hello.xml" << endl;
    return 1;
  }

  try
  {
    auto_ptr<hello_type> h (hello (argv[1]));

    for (hello_type::name::const_iterator i (h->name ().begin ());
         i != h->name ().end ();
         ++i)
    {
      cerr << h->greeting () << ", " << *i << "!" << endl;
    }
  }
  catch (xml_schema::exception const& e)
  {
    cerr << e << endl;
    return 1;
  }
}
