// file      : xsd/cxx/parser/types.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2006 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#ifndef XSD_CXX_PARSER_TYPES_HXX
#define XSD_CXX_PARSER_TYPES_HXX

#include <sstream>

#include <xsd/cxx/parser/elements.hxx>

namespace xsd
{
  namespace cxx
  {
    namespace parser
    {
      // 8-bit
      //
      //

      template <typename C, template<typename, typename> class T>
      struct byte: T<signed char, C>
      {
        typedef signed char type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          short t;
          is >> t;

          v_ = static_cast<type> (t);
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };


      template <typename C, template<typename, typename> class T>
      struct unsigned_byte: T<unsigned char, C>
      {
        typedef unsigned char type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          unsigned short t;
          is >> t;

          v_ = static_cast<type> (t);
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };



      // 16-bit
      //
      //

      template <typename C, template<typename, typename> class T>
      struct short_: T<short, C>
      {
        typedef short type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };


      template <typename C, template<typename, typename> class T>
      struct unsigned_short: T<unsigned short, C>
      {
        typedef unsigned short type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };



      // 32-bit
      //
      //

      template <typename C, template<typename, typename> class T>
      struct int_: T<int, C>
      {
        typedef int type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };


      template <typename C, template<typename, typename> class T>
      struct unsigned_int: T<unsigned int, C>
      {
        typedef unsigned int type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };



      // 64-bit
      //
      //

      template <typename C, template<typename, typename> class T>
      struct long_: T<long long, C>
      {
        typedef long long type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };


      template <typename C, template<typename, typename> class T>
      struct unsigned_long: T<unsigned long long, C>
      {
        typedef unsigned long long type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };



      // Boolean.
      //
      //

      namespace bits
      {
        template<typename C>
        C const*
        true_ ();

        template<typename C>
        C const*
        one ();
      }

      template <typename C, template<typename, typename> class T>
      struct boolean: T<bool, C>
      {
        typedef bool type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          v_ = (s == bits::true_<C> ()) || (s == bits::one<C> ());
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };


      // Floats.
      //
      //

      template <typename C, template<typename, typename> class T>
      struct float_: T<float, C>
      {
        typedef float type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };


      template <typename C, template<typename, typename> class T>
      struct double_: T<double, C>
      {
        typedef double type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };

      template <typename C, template<typename, typename> class T>
      struct decimal: T<long double, C>
      {
        typedef long double type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          std::basic_istringstream<C> is (s);

          is >> v_;
        }

        virtual type
        post ()
        {
          return v_;
        }

      private:
        type v_;
      };



      // String.
      //
      //

      template <typename C, template<typename, typename> class T>
      struct string: T<std::basic_string<C>, C>
      {
        typedef std::basic_string<C> type;

        virtual void
        _characters (std::basic_string<C> const& s)
        {
          s_ = s;
        }

        virtual type
        post ()
        {
          return s_;
        }

      private:
        type s_;
      };
    }
  }
}

#endif  // XSD_CXX_PARSER_TYPES_HXX

#include <xsd/cxx/parser/types.ixx>
