// file      : examples/cxx/parser/library/library.hxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : not copyrighted - public domain

#ifndef LIBRARY_HXX
#define LIBRARY_HXX

#include <string>
#include <vector>

namespace library
{
  //
  //
  typedef unsigned int isbn;


  //
  //
  struct title: std::string
  {
    // lang
    //
    std::string const&
    lang () const
    {
      return lang_;
    }

    void
    lang (std::string const& lang)
    {
      lang_ = lang;
    }

  private:
    std::string lang_;
  };


  //
  //
  enum genre
  {
    romance,
    fiction,
    horror,
    history,
    philosophy
  };


  //
  //
  struct author
  {
    // name
    //
    std::string const&
    name () const
    {
      return name_;
    }

    void
    name (std::string const& name)
    {
      name_ = name;
    }


    // born
    //
    std::string const&
    born () const
    {
      return born_;
    }

    void
    born (std::string const& born)
    {
      born_ = born;
    }


    // died
    //
    std::string const&
    died () const
    {
      return died_;
    }

    void
    died (std::string const& died)
    {
      died_ = died;
    }


    // recommends
    //
    std::string const&
    recommends () const
    {
      return recommends_;
    }

    void
    recommends (std::string const& recommends)
    {
      recommends_ = recommends;
    }

  private:
    std::string name_;
    std::string born_;
    std::string died_;

    std::string recommends_;
  };


  //
  //
  struct book
  {
    // isbn
    //
    library::isbn
    isbn () const
    {
      return isbn_;
    }

    void
    isbn (library::isbn const& isbn)
    {
      isbn_ = isbn;
    }


    // title
    //
    library::title
    title () const
    {
      return title_;
    }

    void
    title (library::title const& title)
    {
      title_ = title;
    }


    // genre
    //
    library::genre
    genre () const
    {
      return genre_;
    }

    void
    genre (library::genre const& genre)
    {
      genre_ = genre;
    }


    // author
    //
    typedef std::vector<library::author> authors;

    authors const&
    author () const
    {
      return author_;
    }

    authors&
    author ()
    {
      return author_;
    }


    // available
    //
    bool
    available () const
    {
      return available_;
    }

    void
    available (bool available)
    {
      available_ = available;
    }


    // id
    //
    std::string const&
    id () const
    {
      return id_;
    }

    void
    id (std::string const& id)
    {
      id_ = id;
    }

  private:
    library::isbn  isbn_;
    library::title title_;
    library::genre genre_;

    authors author_;

    bool available_;
    std::string id_;
  };


  //
  //
  typedef std::vector<book> catalog;
}

#endif // LIBRARY_HXX
